<?php

require_once __DIR__ . '/../AmazonApiGateway.class.inc';

/**
 * \file AWS_notification.php
 * \brief Class to send notifications by the Veremes's service
 *
 * \author Anthony Borghi <anthony.borghi@veremes.com>
 */

Class AWS_notification extends AmazonApiGateway{

	public $sType;  						// Type de notification
	public $aRequiredFields = array();      // Liste des champs requis pour la notification en cours
	public $aOptionalFields = array();      // Liste des champs optionnels pour la notification en cours
	public $oAWSGateway;					// Objet de référence sur l'API gateway
	public $sDeploymentName; 				// Main node of API Deployment 
	public $aRequestParams = array(); 	// Parameter to send the notification
	public $sAppIdentifier = null; 			// Parameter to indentify the app

	public $bError = false;

	// Liste de constante en lien avec l'API gateway du service
	const AWS_API_REGION = 'eu-west-1';
	const AWS_API_ID = '6u2e49upog'; // surement inutile si on utilise Route 53
	const AWS_API_SEND_NOTIFICATION_STAGE = '/addnotification';
	const AWS_API_SEND_NOTIFICATION_METHOD = 'POST';

	/**
     * construct
     * @param {string} $sAwsAccessKeyId Access key ID.
     * @param {string} $sAwsSecretAccessKey Secret access key.
     * @param {string} $sDeploymentName Name of the deployment for this API.
     */
    function __construct ($sAwsAccessKeyId, $sAwsSecretAccessKey, $sDeploymentName, $sAppIdentifier) {
    	parent::__construct($sAwsAccessKeyId, $sAwsSecretAccessKey, self::AWS_API_REGION, self::AWS_API_ID, $sDeploymentName . self::AWS_API_SEND_NOTIFICATION_STAGE);
    	// stockage du noeud principal de déploiement 
    	$this->sDeploymentName = $sDeploymentName;
    	$this->sAppIdentifier = $sAppIdentifier;
    }	

    function defineNotification ($aValues){

    	$aRequiredFieldsFilled = array();
        $aParams = array();

    	foreach ($aValues as $sKey => $mValue) {
    		if (in_array($sKey, $this->aRequiredFields)){
    			$aParams[$sKey] = $mValue;
    			array_push($aRequiredFieldsFilled, $sKey);
    		} else if (in_array($sKey, $this->aOptionalFields)){
    			$aParams[$sKey] = $mValue;
    		}
    	}

        $this->aRequestParams["notificationParams"] = $aParams;// json_encode($aParams);

    	$this->bError = (count($aRequiredFieldsFilled) !== count($this->aRequiredFields));

    	return $this->bError;
    }


    function sendRequestToSendNotification (){

    	if(!empty($this->sAppIdentifier)){	
    		$this->aRequestParams["app_id"] = $this->sAppIdentifier;
    	}
    	
    	$this->aRequestParams["notificationType"] = $this->sType;
        
        $sJsonParams = json_encode($this->aRequestParams);
        //$iParamsLength = strlen($sJsonParams);

    	$sUrl = "https://" . $this->sHost . "/" . $this->sStageName;
    	//$sFullUrl = self::AWS_API_SEND_NOTIFICATION_METHOD . ' ' . $sUrl . ' HTTP/1.1';

        $aAddedHeaders = array('content-type: application/json');

    	$aHeaders = $this->generateGatewayRequestHeaders(self::AWS_API_SEND_NOTIFICATION_METHOD, $sUrl, $aAddedHeaders, $sJsonParams);

    	return $this->curlRequest($sUrl, self::AWS_API_SEND_NOTIFICATION_METHOD, $sJsonParams, $aHeaders);
    }
}

?>