<?php
namespace CoffeeScript;
use \ArrayAccess as ArrayAccess;
/* Driver template for the PHP_ParserGenerator parser generator. (PHP port of LEMON)
*/

/**
 * This can be used to store both the string representation of
 * a token, and any useful meta-data associated with the token.
 *
 * meta-data should be stored as an array
 */
class yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

/** The following structure represents a single element of the
 * parser's stack.  Information stored includes:
 *
 *   +  The state number for the parser at this level of the stack.
 *
 *   +  The value of the token stored at this level of the stack.
 *      (In other words, the "major" token.)
 *
 *   +  The semantic value stored at this level of the stack.  This is
 *      the information used by the action routines in the grammar.
 *      It is sometimes called the "minor" token.
 */
class yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                   ** is the value of the token  */

    public $generated = FALSE;
};

// code external to the class is included here

// declare_class is output here
#line 2 "/var/www/coffeescript-php/grammar.y"
 class Parser #line 104 "/var/www/coffeescript-php/grammar.php"
{
  static $LINE = 0;
  static $FILE = 'unknown';

/* First off, code is included which follows the "include_class" declaration
** in the input file. */

/* Next is all token values, as class constants
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
    const YY_POST_IF                     =  1;
    const YY_IF                          =  2;
    const YY_ELSE                        =  3;
    const YY_FOR                         =  4;
    const YY_DO                          =  5;
    const YY_WHILE                       =  6;
    const YY_UNTIL                       =  7;
    const YY_LOOP                        =  8;
    const YY_SUPER                       =  9;
    const YY_CLASS                       = 10;
    const YY_FORIN                       = 11;
    const YY_FOROF                       = 12;
    const YY_BY                          = 13;
    const YY_WHEN                        = 14;
    const YY_EQUALS                      = 15;
    const YY_COLON                       = 16;
    const YY_COMPOUND_ASSIGN             = 17;
    const YY_RETURN                      = 18;
    const YY_THROW                       = 19;
    const YY_EXTENDS                     = 20;
    const YY_INDENT                      = 21;
    const YY_OUTDENT                     = 22;
    const YY_LOGIC                       = 23;
    const YY_COMPARE                     = 24;
    const YY_RELATION                    = 25;
    const YY_SHIFT                       = 26;
    const YY_PLUS                        = 27;
    const YY_MINUS                       = 28;
    const YY_MATH                        = 29;
    const YY_UNARY                       = 30;
    const YY_EXISTENTIAL                 = 31;
    const YY_INCREMENT                   = 32;
    const YY_DECREMENT                   = 33;
    const YY_CALL_START                  = 34;
    const YY_CALL_END                    = 35;
    const YY_ACCESSOR                    = 36;
    const YY_EXISTENTIAL_ACCESSOR        = 37;
    const YY_PROTOTYPE                   = 38;
    const YY_TERMINATOR                  = 39;
    const YY_STATEMENT                   = 40;
    const YY_IDENTIFIER                  = 41;
    const YY_NUMBER                      = 42;
    const YY_STRING                      = 43;
    const YY_JS                          = 44;
    const YY_REGEX                       = 45;
    const YY_BOOL                        = 46;
    const YY_HERECOMMENT                 = 47;
    const YY_PARAM_START                 = 48;
    const YY_PARAM_END                   = 49;
    const YY_FUNC                        = 50;
    const YY_BOUND_FUNC                  = 51;
    const YY_COMMA                       = 52;
    const YY_RANGE_EXCLUSIVE             = 53;
    const YY_INDEX_START                 = 54;
    const YY_INDEX_END                   = 55;
    const YY_INDEX_SOAK                  = 56;
    const YY_INDEX_PROTO                 = 57;
    const YY_OBJECT_START                = 58;
    const YY_OBJECT_END                  = 59;
    const YY_FUNC_EXIST                  = 60;
    const YY_THIS                        = 61;
    const YY_AT_SIGN                     = 62;
    const YY_ARRAY_START                 = 63;
    const YY_ARRAY_END                   = 64;
    const YY_RANGE_INCLUSIVE             = 65;
    const YY_TRY                         = 66;
    const YY_FINALLY                     = 67;
    const YY_CATCH                       = 68;
    const YY_PAREN_START                 = 69;
    const YY_PAREN_END                   = 70;
    const YY_OWN                         = 71;
    const YY_SWITCH                      = 72;
    const YY_LEADING_WHEN                = 73;
    const YY_NO_ACTION = 510;
    const YY_ACCEPT_ACTION = 509;
    const YY_ERROR_ACTION = 508;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < self::YYNSTATE                              Shift N.  That is,
**                                                        push the lookahead
**                                                        token onto the stack
**                                                        and goto state N.
**
**   self::YYNSTATE <= N < self::YYNSTATE+self::YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == self::YYNSTATE+self::YYNRULE                    A syntax error has occurred.
**
**   N == self::YYNSTATE+self::YYNRULE+1                  The parser accepts its
**                                                        input. (and concludes parsing)
**
**   N == self::YYNSTATE+self::YYNRULE+2                  No such action.  Denotes unused
**                                                        slots in the yy_action[] table.
**
** The action table is constructed as a single large static array $yy_action.
** Given state S and lookahead X, the action is computed as
**
**      self::$yy_action[self::$yy_shift_ofst[S] + X ]
**
** If the index value self::$yy_shift_ofst[S]+X is out of range or if the value
** self::$yy_lookahead[self::$yy_shift_ofst[S]+X] is not equal to X or if
** self::$yy_shift_ofst[S] is equal to self::YY_SHIFT_USE_DFLT, it means that
** the action is not in the table and that self::$yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the static $yy_reduce_ofst array is used in place of
** the static $yy_shift_ofst array and self::YY_REDUCE_USE_DFLT is used in place of
** self::YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  self::$yy_action        A single table containing all actions.
**  self::$yy_lookahead     A table containing the lookahead for each entry in
**                          yy_action.  Used to detect hash collisions.
**  self::$yy_shift_ofst    For each state, the offset into self::$yy_action for
**                          shifting terminals.
**  self::$yy_reduce_ofst   For each state, the offset into self::$yy_action for
**                          shifting non-terminals after a reduce.
**  self::$yy_default       Default action for each state.
*/
    const YY_SZ_ACTTAB = 4481;
static public $yy_action = array(
 /*     0 */   509,  182,  181,  233,   88,  115,  286,  281,  223,  102,
 /*    10 */   105,  251,  247,  248,  249,  250,  257,  258,  265,  266,
 /*    20 */   234,  263,  236,  186,  226,  227,  235,   48,  155,  311,
 /*    30 */    43,   51,  241,  240,  225,  162,  139,  237,  238,  239,
 /*    40 */    25,   35,   23,   36,   32,   49,   48,  246,  311,  245,
 /*    50 */   132,  158,  305,  151,  132,  292,    1,   13,  126,  128,
 /*    60 */   184,   80,  116,  286,  281,  223,  102,  105,  251,  247,
 /*    70 */   248,  249,  250,  257,  258,  265,  266,  234,  263,  236,
 /*    80 */   186,   52,    7,  235,   66,  155,   40,   34,  309,  241,
 /*    90 */   240,  290,  162,  244,  237,  238,  239,   35,   23,   36,
 /*   100 */    32,   49,   48,  140,  311,  283,   14,   24,  158,  305,
 /*   110 */   151,  132,   32,   49,   48,  291,  311,  184,   68,  116,
 /*   120 */   286,  281,  223,  102,  105,  251,  247,  248,  249,  250,
 /*   130 */   257,  258,  265,  266,  234,  263,  236,  186,  154,  156,
 /*   140 */   235,  244,  155,   64,  220,  213,  241,  240,  290,  162,
 /*   150 */   206,  237,  238,  239,  215,  173,  209,  207,   60,  210,
 /*   160 */   147,  134,  283,    2,   65,  158,  305,  151,  132,   33,
 /*   170 */    22,  214,  188,  166,  184,   80,  116,  286,  281,  223,
 /*   180 */   102,  105,  251,  247,  248,  249,  250,  257,  258,  265,
 /*   190 */   266,  234,  263,  236,  186,  218,  176,  235,  228,  155,
 /*   200 */   224,  132,   31,  241,  240,  290,  162,  303,  237,  238,
 /*   210 */   239,  179,   23,   36,   32,   49,   48,  145,  311,  283,
 /*   220 */   307,    7,  158,  305,  151,  132,  278,  133,   13,  310,
 /*   230 */   272,  184,   80,  116,  286,  281,  223,  102,  105,  251,
 /*   240 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*   250 */   236,  186,  129,  270,  235,    7,  155,  127,  270,  304,
 /*   260 */   241,  240,  290,  162,  130,  237,  238,  239,   36,   32,
 /*   270 */    49,   48,  210,  311,  144,  246,  283,  245,  132,  158,
 /*   280 */   305,  151,  132,  279,  214,  188,   21,  159,  184,   80,
 /*   290 */   116,  286,  281,  223,  102,  105,  251,  247,  248,  249,
 /*   300 */   250,  257,  258,  265,  266,  234,  263,  236,  186,  208,
 /*   310 */   308,  235,   17,  155,  191,   44,   13,  241,  240,  290,
 /*   320 */   162,   15,  237,  238,  239,  229,    5,  243,  242,   16,
 /*   330 */   302,  147,  246,  283,  245,  132,  158,  305,  151,  132,
 /*   340 */   221,   74,   13,  294,   10,  184,   69,  116,  286,  281,
 /*   350 */   223,  102,  105,  251,  247,  248,  249,  250,  257,  258,
 /*   360 */   265,  266,  234,  263,  236,  186,  274,  222,  235,  244,
 /*   370 */   155,  153,  268,    3,  241,  240,  138,  162,  262,  237,
 /*   380 */   238,  239,  183,  180,  190,  189,   60,  177,  230,   50,
 /*   390 */   137,    2,   14,  158,  305,  151,  132,  311,  299,  275,
 /*   400 */   276,  255,  184,   80,  116,  286,  281,  223,  102,  105,
 /*   410 */   251,  247,  248,  249,  250,  257,  258,  265,  266,  234,
 /*   420 */   263,  236,  186,  175,  256,  235,   11,  155,  232,  168,
 /*   430 */    37,  241,  240,  290,  162,  297,  237,  238,  239,    5,
 /*   440 */    25,   35,   23,   36,   32,   49,   48,  289,  311,  252,
 /*   450 */   158,  305,  151,  132,  164,  253,  167,   10,  171,  184,
 /*   460 */   233,   88,  115,  286,  281,  223,  102,  105,  251,  247,
 /*   470 */   248,  249,  250,  257,  258,  265,  266,  234,  263,  236,
 /*   480 */   186,  178,  287,  235,  165,  155,    5,  284,   28,  241,
 /*   490 */   240,  169,  162,  332,  237,  238,  239,   25,   35,   23,
 /*   500 */    36,   32,   49,   48,   10,  311,  332,  332,  158,  305,
 /*   510 */   151,  132,  332,  332,  332,  332,  332,  184,   80,  116,
 /*   520 */   286,  281,  223,  102,  105,  251,  247,  248,  249,  250,
 /*   530 */   257,  258,  265,  266,  234,  263,  236,  186,  332,  332,
 /*   540 */   235,  332,  155,  332,  332,  332,  241,  240,  290,  162,
 /*   550 */   332,  237,  238,  239,  332,   25,   35,   23,   36,   32,
 /*   560 */    49,   48,  282,  311,  332,  158,  305,  151,  132,  332,
 /*   570 */   332,  332,  332,  174,  184,  233,   88,  115,  286,  281,
 /*   580 */   223,  102,  105,  251,  247,  248,  249,  250,  257,  258,
 /*   590 */   265,  266,  234,  263,  236,  186,  300,  332,  235,  332,
 /*   600 */   155,    5,  285,   42,  241,  240,  332,  162,  332,  237,
 /*   610 */   238,  239,   25,   35,   23,   36,   32,   49,   48,   10,
 /*   620 */   311,  332,  332,  158,  305,  151,  132,  332,  332,  254,
 /*   630 */   312,  332,  184,  277,  277,  332,  332,  142,  135,  172,
 /*   640 */   332,  233,   88,  115,  286,  281,  223,  102,  105,  251,
 /*   650 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*   660 */   236,  186,  332,  192,  235,  332,  155,  332,  332,  374,
 /*   670 */   241,  240,  332,  162,  332,  237,  238,  239,   53,  332,
 /*   680 */    66,  332,   40,   34,   12,  143,   55,  374,  332,  158,
 /*   690 */   305,  151,  132,  332,   54,   38,  332,  312,  184,  332,
 /*   700 */   374,  277,  332,   19,   20,  135,   26,   46,   58,   56,
 /*   710 */   332,  246,  374,  245,  132,  332,  306,  244,  267,  264,
 /*   720 */   259,  260,  261,  231,   62,  332,  226,  227,  312,  194,
 /*   730 */   332,  332,  277,  332,   60,  332,  135,  293,  150,    4,
 /*   740 */    47,  295,  152,  332,  246,    8,  245,  132,   18,  273,
 /*   750 */   332,   94,  116,  286,  281,  223,  102,  105,  251,  247,
 /*   760 */   248,  249,  250,  257,  258,  265,  266,  234,  263,  236,
 /*   770 */   186,   61,  198,  235,  332,  155,  149,  332,  332,  241,
 /*   780 */   240,  220,  162,  332,  237,  238,  239,  206,  170,   63,
 /*   790 */   332,  219,  173,  209,  207,  271,  332,  332,  158,  305,
 /*   800 */   151,  132,  332,  332,  332,  332,  332,  184,  211,   88,
 /*   810 */   115,  286,  281,  223,  102,  105,  251,  247,  248,  249,
 /*   820 */   250,  257,  258,  265,  266,  234,  263,  236,  186,  332,
 /*   830 */   332,  235,  332,  155,  332,  195,  332,  241,  240,  332,
 /*   840 */   162,  332,  237,  238,  239,  332,   14,  196,  199,  332,
 /*   850 */   332,  204,  185,  216,  332,  332,  158,  305,  151,  132,
 /*   860 */   332,  332,  332,  332,  332,  184,   91,  116,  286,  281,
 /*   870 */   223,  102,  105,  251,  247,  248,  249,  250,  257,  258,
 /*   880 */   265,  266,  234,  263,  236,  186,  332,   61,  235,  332,
 /*   890 */   155,  332,  332,  332,  241,  240,  332,  162,  332,  237,
 /*   900 */   238,  239,   53,  332,   66,   63,   40,   34,   12,  143,
 /*   910 */    55,  131,  332,  158,  305,  151,  132,  332,   54,   38,
 /*   920 */   332,    6,  184,  332,  332,  193,  332,   19,   20,  332,
 /*   930 */    26,  332,   58,   56,  332,  205,  332,  332,  332,  332,
 /*   940 */   306,  244,  267,  264,  259,  260,  261,  231,   62,  332,
 /*   950 */   226,  227,  210,  244,  267,  264,  244,  332,   60,  231,
 /*   960 */   332,  293,  150,    4,  214,  188,  152,  332,  332,    8,
 /*   970 */   201,  332,   18,   60,  137,   53,  332,   66,    4,   40,
 /*   980 */    34,   12,  143,   55,  332,  332,   67,  332,  217,  176,
 /*   990 */   332,   54,   38,  332,    6,  332,  332,  332,  332,  332,
 /*  1000 */    19,   20,  332,   26,  332,   58,   56,  332,  332,  332,
 /*  1010 */   332,  332,  332,  306,  244,  267,  264,  259,  260,  261,
 /*  1020 */   231,   62,  332,  226,  227,  332,  332,  332,  332,  332,
 /*  1030 */   332,   60,  332,  332,  293,  150,    4,  280,  332,  152,
 /*  1040 */   332,  332,    8,  332,  332,   18,   77,  116,  286,  281,
 /*  1050 */   223,  102,  105,  251,  247,  248,  249,  250,  257,  258,
 /*  1060 */   265,  266,  234,  263,  236,  186,  332,  332,  235,  332,
 /*  1070 */   155,  332,  332,  332,  241,  240,  332,  162,  332,  237,
 /*  1080 */   238,  239,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  1090 */   332,  332,  332,  158,  305,  151,  132,  332,  332,  332,
 /*  1100 */   332,  332,  184,  109,  116,  286,  281,  223,  102,  105,
 /*  1110 */   251,  247,  248,  249,  250,  257,  258,  265,  266,  234,
 /*  1120 */   263,  236,  186,  332,  332,  235,  332,  155,  332,  195,
 /*  1130 */   332,  241,  240,  332,  162,  332,  237,  238,  239,  332,
 /*  1140 */   332,  196,  199,  332,  332,  202,  185,  216,  332,  332,
 /*  1150 */   158,  305,  151,  132,  332,  332,  332,  332,  332,  184,
 /*  1160 */   117,  116,  286,  281,  223,  102,  105,  251,  247,  248,
 /*  1170 */   249,  250,  257,  258,  265,  266,  234,  263,  236,  186,
 /*  1180 */   332,  332,  235,  332,  155,  332,  332,  332,  241,  240,
 /*  1190 */   332,  162,  332,  237,  238,  239,  332,  332,  332,  332,
 /*  1200 */   332,  332,  332,  332,  332,  332,  332,  158,  305,  151,
 /*  1210 */   132,  332,  332,  332,  332,  332,  184,   84,  116,  286,
 /*  1220 */   281,  223,  102,  105,  251,  247,  248,  249,  250,  257,
 /*  1230 */   258,  265,  266,  234,  263,  236,  186,  332,  332,  235,
 /*  1240 */   332,  155,  332,  332,  332,  241,  240,  332,  162,  332,
 /*  1250 */   237,  238,  239,  332,  332,  332,  332,  332,  332,  332,
 /*  1260 */   332,  332,  332,  332,  158,  305,  151,  132,  332,  332,
 /*  1270 */   332,  332,  332,  184,   71,  116,  286,  281,  223,  102,
 /*  1280 */   105,  251,  247,  248,  249,  250,  257,  258,  265,  266,
 /*  1290 */   234,  263,  236,  186,  332,  332,  235,  332,  155,  332,
 /*  1300 */   332,  332,  241,  240,  332,  162,  332,  237,  238,  239,
 /*  1310 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  1320 */   332,  158,  305,  151,  132,  332,  332,  332,  332,  332,
 /*  1330 */   184,   93,  116,  286,  281,  223,  102,  105,  251,  247,
 /*  1340 */   248,  249,  250,  257,  258,  265,  266,  234,  263,  236,
 /*  1350 */   186,  332,  332,  235,  332,  155,  332,  332,  332,  241,
 /*  1360 */   240,  332,  162,  332,  237,  238,  239,  332,  332,  332,
 /*  1370 */   332,  332,  332,  332,  332,  332,  332,  332,  158,  305,
 /*  1380 */   151,  132,  332,  332,  332,  332,  332,  184,  103,  116,
 /*  1390 */   286,  281,  223,  102,  105,  251,  247,  248,  249,  250,
 /*  1400 */   257,  258,  265,  266,  234,  263,  236,  186,  332,  332,
 /*  1410 */   235,  332,  155,  332,  332,  332,  241,  240,  332,  162,
 /*  1420 */   332,  237,  238,  239,  332,  332,  332,  332,  332,  332,
 /*  1430 */   332,  332,  332,  332,  332,  158,  305,  151,  132,  332,
 /*  1440 */   332,  332,  332,  332,  184,   83,  116,  286,  281,  223,
 /*  1450 */   102,  105,  251,  247,  248,  249,  250,  257,  258,  265,
 /*  1460 */   266,  234,  263,  236,  186,  332,  332,  235,  332,  155,
 /*  1470 */   332,  332,  332,  241,  240,  332,  162,  332,  237,  238,
 /*  1480 */   239,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  1490 */   332,  332,  158,  305,  151,  132,  332,  332,  332,  332,
 /*  1500 */   332,  184,   78,  116,  286,  281,  223,  102,  105,  251,
 /*  1510 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*  1520 */   236,  186,  332,  332,  235,  332,  155,  332,  332,  332,
 /*  1530 */   241,  240,  332,  162,  332,  237,  238,  239,  332,  332,
 /*  1540 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  158,
 /*  1550 */   305,  151,  132,  332,  332,  332,  332,  332,  184,   85,
 /*  1560 */   116,  286,  281,  223,  102,  105,  251,  247,  248,  249,
 /*  1570 */   250,  257,  258,  265,  266,  234,  263,  236,  186,  332,
 /*  1580 */   332,  235,  332,  155,  332,  332,  332,  241,  240,  332,
 /*  1590 */   162,  332,  237,  238,  239,  332,  332,  332,  332,  332,
 /*  1600 */   332,  332,  332,  332,  332,  332,  158,  305,  151,  132,
 /*  1610 */   332,  332,  332,  332,  332,  184,  121,  116,  286,  281,
 /*  1620 */   223,  102,  105,  251,  247,  248,  249,  250,  257,  258,
 /*  1630 */   265,  266,  234,  263,  236,  186,  332,  332,  235,  332,
 /*  1640 */   155,  332,  332,  332,  241,  240,  332,  162,  332,  237,
 /*  1650 */   238,  239,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  1660 */   332,  332,  332,  158,  305,  151,  132,  332,  332,  332,
 /*  1670 */   332,  332,  184,  122,  116,  286,  281,  223,  102,  105,
 /*  1680 */   251,  247,  248,  249,  250,  257,  258,  265,  266,  234,
 /*  1690 */   263,  236,  186,  332,  332,  235,  332,  155,  332,  332,
 /*  1700 */   332,  241,  240,  332,  162,  332,  237,  238,  239,  332,
 /*  1710 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  1720 */   158,  305,  151,  132,  332,  332,  332,  332,  332,  184,
 /*  1730 */    75,  116,  286,  281,  223,  102,  105,  251,  247,  248,
 /*  1740 */   249,  250,  257,  258,  265,  266,  234,  263,  236,  186,
 /*  1750 */   332,  332,  235,  332,  155,  332,  332,  332,  241,  240,
 /*  1760 */   332,  162,  332,  237,  238,  239,  332,  332,  332,  332,
 /*  1770 */   332,  332,  332,  332,  332,  332,  332,  158,  305,  151,
 /*  1780 */   132,  332,  332,  332,  332,  332,  184,  114,  116,  286,
 /*  1790 */   281,  223,  102,  105,  251,  247,  248,  249,  250,  257,
 /*  1800 */   258,  265,  266,  234,  263,  236,  186,  332,  332,  235,
 /*  1810 */   332,  155,  332,  332,  332,  241,  240,  332,  162,  332,
 /*  1820 */   237,  238,  239,  332,  332,  332,  332,  332,  332,  332,
 /*  1830 */   332,  332,  332,  332,  158,  305,  151,  132,  332,  332,
 /*  1840 */   332,  332,  332,  184,  108,  116,  286,  281,  223,  102,
 /*  1850 */   105,  251,  247,  248,  249,  250,  257,  258,  265,  266,
 /*  1860 */   234,  263,  236,  186,  332,  332,  235,  332,  155,  332,
 /*  1870 */   332,  332,  241,  240,  332,  162,  332,  237,  238,  239,
 /*  1880 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  1890 */   332,  158,  305,  151,  132,  332,  332,  332,  332,  332,
 /*  1900 */   184,   99,  116,  286,  281,  223,  102,  105,  251,  247,
 /*  1910 */   248,  249,  250,  257,  258,  265,  266,  234,  263,  236,
 /*  1920 */   186,  332,  332,  235,  332,  155,  332,  332,  332,  241,
 /*  1930 */   240,  332,  162,  332,  237,  238,  239,  332,  332,  332,
 /*  1940 */   332,  332,  332,  332,  332,  332,  332,  332,  158,  305,
 /*  1950 */   151,  132,  332,  332,  332,  332,  332,  184,   92,  116,
 /*  1960 */   286,  281,  223,  102,  105,  251,  247,  248,  249,  250,
 /*  1970 */   257,  258,  265,  266,  234,  263,  236,  186,  332,  332,
 /*  1980 */   235,  332,  155,  332,  332,  332,  241,  240,  332,  162,
 /*  1990 */   332,  237,  238,  239,  332,  332,  332,  332,  332,  332,
 /*  2000 */   332,  332,  332,  332,  332,  158,  305,  151,  132,  332,
 /*  2010 */   332,  332,  332,  332,  184,   76,  116,  286,  281,  223,
 /*  2020 */   102,  105,  251,  247,  248,  249,  250,  257,  258,  265,
 /*  2030 */   266,  234,  263,  236,  186,  332,  332,  235,  332,  155,
 /*  2040 */   332,  332,  332,  241,  240,  332,  162,  332,  237,  238,
 /*  2050 */   239,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  2060 */   332,  332,  158,  305,  151,  132,  332,  332,  332,  332,
 /*  2070 */   332,  184,   90,  116,  286,  281,  223,  102,  105,  251,
 /*  2080 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*  2090 */   236,  186,  332,  332,  235,  332,  155,  332,  332,  332,
 /*  2100 */   241,  240,  332,  162,  332,  237,  238,  239,  332,  332,
 /*  2110 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  158,
 /*  2120 */   305,  151,  132,  332,  332,  332,  332,  332,  184,  107,
 /*  2130 */   116,  286,  281,  223,  102,  105,  251,  247,  248,  249,
 /*  2140 */   250,  257,  258,  265,  266,  234,  263,  236,  186,  332,
 /*  2150 */   332,  235,  332,  155,  332,  332,  332,  241,  240,  332,
 /*  2160 */   162,  332,  237,  238,  239,  332,  332,  332,  332,  332,
 /*  2170 */   332,  332,  332,  332,  332,  332,  158,  305,  151,  132,
 /*  2180 */   332,  332,  332,  332,  332,  184,  113,  116,  286,  281,
 /*  2190 */   223,  102,  105,  251,  247,  248,  249,  250,  257,  258,
 /*  2200 */   265,  266,  234,  263,  236,  186,  332,  332,  235,  332,
 /*  2210 */   155,  332,  332,  332,  241,  240,  332,  162,  332,  237,
 /*  2220 */   238,  239,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  2230 */   332,  332,  332,  158,  305,  151,  132,  332,  332,  332,
 /*  2240 */   332,  332,  184,  104,  116,  286,  281,  223,  102,  105,
 /*  2250 */   251,  247,  248,  249,  250,  257,  258,  265,  266,  234,
 /*  2260 */   263,  236,  186,  332,  332,  235,  332,  155,  332,  332,
 /*  2270 */   332,  241,  240,  332,  162,  332,  237,  238,  239,  332,
 /*  2280 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  2290 */   158,  305,  151,  132,  332,  332,  332,  332,  332,  184,
 /*  2300 */    95,  116,  286,  281,  223,  102,  105,  251,  247,  248,
 /*  2310 */   249,  250,  257,  258,  265,  266,  234,  263,  236,  186,
 /*  2320 */   332,  332,  235,  332,  155,  332,  332,  332,  241,  240,
 /*  2330 */   332,  162,  332,  237,  238,  239,  332,  332,  332,  332,
 /*  2340 */   332,  332,  332,  332,  332,  332,  332,  158,  305,  151,
 /*  2350 */   132,  332,  332,  332,  332,  332,  184,   87,  116,  286,
 /*  2360 */   281,  223,  102,  105,  251,  247,  248,  249,  250,  257,
 /*  2370 */   258,  265,  266,  234,  263,  236,  186,  332,  332,  235,
 /*  2380 */   332,  155,  332,  332,  332,  241,  240,  332,  162,  332,
 /*  2390 */   237,  238,  239,  332,  332,  332,  332,  332,  332,  332,
 /*  2400 */   332,  332,  332,  332,  158,  305,  151,  132,  332,  332,
 /*  2410 */   332,  332,  332,  184,  112,  116,  286,  281,  223,  102,
 /*  2420 */   105,  251,  247,  248,  249,  250,  257,  258,  265,  266,
 /*  2430 */   234,  263,  236,  186,  332,  332,  235,  332,  155,  332,
 /*  2440 */   332,  332,  241,  240,  332,  162,  332,  237,  238,  239,
 /*  2450 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  2460 */   332,  158,  305,  151,  132,  332,  332,  332,  332,  332,
 /*  2470 */   184,   97,  116,  286,  281,  223,  102,  105,  251,  247,
 /*  2480 */   248,  249,  250,  257,  258,  265,  266,  234,  263,  236,
 /*  2490 */   186,  332,  332,  235,  332,  155,  332,  332,  332,  241,
 /*  2500 */   240,  332,  162,  332,  237,  238,  239,  332,  332,  332,
 /*  2510 */   332,  332,  332,  332,  332,  332,  332,  332,  158,  305,
 /*  2520 */   151,  132,  332,  332,  332,  332,  332,  184,  119,  116,
 /*  2530 */   286,  281,  223,  102,  105,  251,  247,  248,  249,  250,
 /*  2540 */   257,  258,  265,  266,  234,  263,  236,  186,  332,  332,
 /*  2550 */   235,  332,  155,  332,  332,  332,  241,  240,  332,  162,
 /*  2560 */   332,  237,  238,  239,  332,  332,  332,  332,  332,  332,
 /*  2570 */   332,  332,  332,  332,  332,  158,  305,  151,  132,  332,
 /*  2580 */   332,  332,  332,  332,  184,   96,  116,  286,  281,  223,
 /*  2590 */   102,  105,  251,  247,  248,  249,  250,  257,  258,  265,
 /*  2600 */   266,  234,  263,  236,  186,  332,  332,  235,  332,  155,
 /*  2610 */   332,  332,  332,  241,  240,  332,  162,  332,  237,  238,
 /*  2620 */   239,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  2630 */   332,  332,  158,  305,  151,  132,  332,  332,  332,  332,
 /*  2640 */   332,  184,   82,  116,  286,  281,  223,  102,  105,  251,
 /*  2650 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*  2660 */   236,  186,  332,  332,  235,  332,  155,  332,  332,  332,
 /*  2670 */   241,  240,  332,  162,  332,  237,  238,  239,   53,  332,
 /*  2680 */    66,  332,   40,   34,   12,  143,   55,  332,  332,  158,
 /*  2690 */   305,  151,  132,  332,   54,   38,  332,    7,  184,  332,
 /*  2700 */   332,  332,  332,   19,   20,  332,   26,  332,   58,   56,
 /*  2710 */   332,  332,  332,  332,  332,  332,  306,  244,  267,  264,
 /*  2720 */   259,  260,  261,  231,   62,  332,  226,  227,  332,  332,
 /*  2730 */   332,  332,  332,  332,   60,  332,  332,  293,  150,    4,
 /*  2740 */   332,  332,  152,  332,  332,    8,  332,  332,   18,  332,
 /*  2750 */   332,   53,  332,   66,  332,   40,   34,   12,  143,   55,
 /*  2760 */   332,  332,  332,  332,  332,  332,  332,   54,   38,  332,
 /*  2770 */    27,  332,  332,  332,  332,  332,   19,   20,  332,   26,
 /*  2780 */   332,   58,   56,  332,  332,  332,  332,  332,  332,  306,
 /*  2790 */   244,  267,  264,  259,  260,  261,  231,   62,  332,  226,
 /*  2800 */   227,  332,  332,  332,  332,  332,  332,   60,  332,  332,
 /*  2810 */   293,  150,    4,  332,  332,  152,  332,  332,    8,  332,
 /*  2820 */   332,   18,  101,  116,  286,  281,  223,  102,  105,  251,
 /*  2830 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*  2840 */   236,  186,  332,  332,  235,  332,  155,  332,  332,  332,
 /*  2850 */   241,  240,  332,  162,  332,  237,  238,  239,   53,  332,
 /*  2860 */    66,  332,   40,   34,   12,  143,   55,  332,  332,  158,
 /*  2870 */   305,  151,  132,  332,   54,   38,  332,   41,  184,  332,
 /*  2880 */   332,  332,  332,   19,   20,  332,   26,  332,   58,   56,
 /*  2890 */   332,  332,  332,  332,  332,  332,  306,  244,  267,  264,
 /*  2900 */   259,  260,  261,  231,   62,  332,  226,  227,  332,  332,
 /*  2910 */   332,  332,  332,  332,   60,  332,  332,  293,  150,    4,
 /*  2920 */   332,  332,  152,  332,  332,    8,  332,  332,   18,  332,
 /*  2930 */   332,   53,  332,   66,  332,   40,   34,   12,  143,   55,
 /*  2940 */   332,  332,  332,  332,  332,  332,  332,   54,   38,  332,
 /*  2950 */    45,  332,  332,  332,  332,  332,   19,   20,  332,   26,
 /*  2960 */   332,   58,   56,  332,  332,  332,  332,  332,  332,  306,
 /*  2970 */   244,  267,  264,  259,  260,  261,  231,   62,  332,  226,
 /*  2980 */   227,  332,  332,  332,  332,  332,  332,   60,  332,  332,
 /*  2990 */   293,  150,    4,  332,  332,  152,  332,  332,    8,  332,
 /*  3000 */   332,   18,   70,  116,  286,  281,  223,  102,  105,  251,
 /*  3010 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*  3020 */   236,  186,  332,  332,  235,  332,  155,  332,  332,  332,
 /*  3030 */   241,  240,  332,  162,  332,  237,  238,  239,  332,  332,
 /*  3040 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  158,
 /*  3050 */   305,  151,  132,  332,  332,  332,  332,  332,  184,  100,
 /*  3060 */   116,  286,  281,  223,  102,  105,  251,  247,  248,  249,
 /*  3070 */   250,  257,  258,  265,  266,  234,  263,  236,  186,  332,
 /*  3080 */   332,  235,  332,  155,  332,  332,  332,  241,  240,  332,
 /*  3090 */   162,  332,  237,  238,  239,   53,  332,   66,  332,   40,
 /*  3100 */    34,   12,  143,   55,  332,  332,  158,  305,  151,  132,
 /*  3110 */   332,   54,   38,  332,    6,  184,  332,  332,  332,  332,
 /*  3120 */    19,   20,  332,   26,  332,   58,   56,  332,  332,  332,
 /*  3130 */   332,  332,  332,  306,  244,  267,  264,  259,  260,  261,
 /*  3140 */   231,   62,  332,  226,  227,  332,  332,  332,  332,  332,
 /*  3150 */   332,   60,  332,  332,  293,  150,    4,  332,  332,  152,
 /*  3160 */   332,  332,    8,  332,  332,   18,  332,  332,   53,  332,
 /*  3170 */    66,  332,   40,   34,   12,  143,   55,  332,  332,  332,
 /*  3180 */   332,  332,  332,  332,   54,   38,  332,  332,  187,  332,
 /*  3190 */   332,  332,  332,   19,   20,  332,   26,  332,   58,   56,
 /*  3200 */   332,  332,  332,  332,  332,  332,  306,  244,  267,  264,
 /*  3210 */   259,  260,  261,  231,   62,  332,  226,  227,  332,  332,
 /*  3220 */   332,  332,  332,  332,   60,  332,  332,  293,  150,    4,
 /*  3230 */   332,  332,  152,  332,  332,    8,  332,  332,   18,  332,
 /*  3240 */   332,   53,  332,   66,  332,   40,   34,   12,  143,   55,
 /*  3250 */   332,  332,  332,  332,  332,  332,  332,   54,   38,  332,
 /*  3260 */     9,  332,  332,  332,  332,  332,   19,   20,  332,   26,
 /*  3270 */   332,   58,   56,  332,  332,  332,  332,  332,  332,  306,
 /*  3280 */   244,  267,  264,  259,  260,  261,  231,   62,  332,  226,
 /*  3290 */   227,  332,  332,  332,  332,  332,  332,   60,  332,  332,
 /*  3300 */   293,  150,    4,  332,  332,  152,  332,  332,    8,  332,
 /*  3310 */   332,   18,  106,  116,  286,  281,  223,  102,  105,  251,
 /*  3320 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*  3330 */   236,  186,  332,  332,  235,  332,  155,  332,  332,  332,
 /*  3340 */   241,  240,  332,  162,  332,  237,  238,  239,  332,  332,
 /*  3350 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  158,
 /*  3360 */   305,  151,  132,  332,  332,  332,  332,  332,  184,   86,
 /*  3370 */   116,  286,  281,  223,  102,  105,  251,  247,  248,  249,
 /*  3380 */   250,  257,  258,  265,  266,  234,  263,  236,  186,  332,
 /*  3390 */   332,  235,  332,  155,  332,  332,  332,  241,  240,  332,
 /*  3400 */   162,  332,  237,  238,  239,  332,  332,  332,  332,  332,
 /*  3410 */   332,  332,  332,  332,  332,  332,  158,  305,  151,  132,
 /*  3420 */   332,  332,  332,  332,  332,  184,  120,  116,  286,  281,
 /*  3430 */   223,  102,  105,  251,  247,  248,  249,  250,  257,  258,
 /*  3440 */   265,  266,  234,  263,  236,  186,  332,  332,  235,  332,
 /*  3450 */   155,  332,  332,  332,  241,  240,  332,  162,  332,  237,
 /*  3460 */   238,  239,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3470 */   332,  332,  332,  158,  305,  151,  132,  332,  332,  332,
 /*  3480 */   332,  332,  184,  118,  116,  286,  281,  223,  102,  105,
 /*  3490 */   251,  247,  248,  249,  250,  257,  258,  265,  266,  234,
 /*  3500 */   263,  236,  186,  332,  332,  235,  332,  155,  332,  332,
 /*  3510 */   332,  241,  240,  332,  162,  332,  237,  238,  239,  332,
 /*  3520 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3530 */   158,  305,  151,  132,  332,  332,  332,  332,  332,  184,
 /*  3540 */    89,  116,  286,  281,  223,  102,  105,  251,  247,  248,
 /*  3550 */   249,  250,  257,  258,  265,  266,  234,  263,  236,  186,
 /*  3560 */   332,  332,  235,  332,  155,  332,  332,  332,  241,  240,
 /*  3570 */   332,  162,  332,  237,  238,  239,  332,  332,  332,  332,
 /*  3580 */   332,  332,  332,  332,  332,  332,  332,  158,  305,  151,
 /*  3590 */   132,  332,  332,  332,  332,  332,  184,   79,  116,  286,
 /*  3600 */   281,  223,  102,  105,  251,  247,  248,  249,  250,  257,
 /*  3610 */   258,  265,  266,  234,  263,  236,  186,  332,  332,  235,
 /*  3620 */   332,  155,  332,  332,  332,  241,  240,  332,  162,  332,
 /*  3630 */   237,  238,  239,   53,  332,   66,  332,   40,   34,   12,
 /*  3640 */   143,   55,  332,  332,  158,  305,  151,  132,  332,   54,
 /*  3650 */    38,  332,  124,  184,  332,  332,  332,  332,   19,   20,
 /*  3660 */   332,   26,  332,   58,   56,  332,  332,  332,  332,  332,
 /*  3670 */   332,  306,  244,  267,  264,  259,  260,  261,  231,   62,
 /*  3680 */   332,  226,  227,  332,  332,  332,  332,  332,  332,   60,
 /*  3690 */   332,  332,  293,  150,    4,  332,  332,  152,  332,  332,
 /*  3700 */     8,  332,  332,   18,  332,   98,  116,  286,  281,  223,
 /*  3710 */   102,  105,  251,  247,  248,  249,  250,  257,  258,  265,
 /*  3720 */   266,  234,  263,  236,  186,  332,  332,  235,  332,  155,
 /*  3730 */   332,  332,  332,  241,  240,  332,  162,  332,  237,  238,
 /*  3740 */   239,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3750 */   332,  332,  158,  305,  151,  132,  332,  332,  332,  332,
 /*  3760 */   332,  184,   81,  116,  286,  281,  223,  102,  105,  251,
 /*  3770 */   247,  248,  249,  250,  257,  258,  265,  266,  234,  263,
 /*  3780 */   236,  186,  332,  332,  235,  332,  155,  332,  332,  332,
 /*  3790 */   241,  240,  332,  162,  332,  237,  238,  239,   53,  332,
 /*  3800 */    66,  332,   40,   34,   12,  143,   55,  332,  332,  158,
 /*  3810 */   305,  151,  132,  332,   54,   38,  332,  332,  184,  332,
 /*  3820 */   332,  332,  332,   19,   20,  332,   26,  332,   58,   56,
 /*  3830 */   332,  332,  332,  332,  332,  332,  306,  244,  267,  264,
 /*  3840 */   259,  260,  261,  231,   62,  332,  226,  227,  332,  148,
 /*  3850 */   136,  146,  332,  332,   60,  332,  332,  293,  150,    4,
 /*  3860 */   332,  332,  152,  332,  332,    8,  332,    1,   18,  126,
 /*  3870 */   128,   53,  415,  269,  148,  136,  146,   12,  143,   55,
 /*  3880 */   332,  332,  332,  332,  332,  332,  332,   54,   38,  332,
 /*  3890 */   332,  332,    1,  332,  126,  128,   19,   20,  269,   26,
 /*  3900 */   332,   58,   56,  332,  332,  332,  332,  332,  332,  306,
 /*  3910 */   244,  267,  264,  259,  260,  261,  231,   62,  332,  226,
 /*  3920 */   227,  332,  143,  332,  332,  332,  332,   60,  332,  332,
 /*  3930 */   293,  150,    4,   57,    7,  152,  332,  332,    8,  332,
 /*  3940 */    30,   18,  332,   66,  332,   40,   34,  332,  332,  332,
 /*  3950 */   332,  332,  332,  332,  244,  267,  264,  259,  260,  261,
 /*  3960 */   332,  332,   25,   35,   23,   36,   32,   49,   48,  332,
 /*  3970 */   311,   60,  332,  332,  293,  150,    4,  332,  332,  332,
 /*  3980 */   332,  332,    8,  332,   30,    7,  332,   66,  332,   40,
 /*  3990 */    34,  332,  163,  332,  332,  332,  332,  332,  415,  332,
 /*  4000 */   148,  136,  146,  332,  295,  332,   25,   35,   23,   36,
 /*  4010 */    32,   49,   48,  332,  311,  332,  195,  332,    1,  313,
 /*  4020 */   126,  128,  332,  332,  269,  332,  110,  111,  196,  199,
 /*  4030 */   332,  332,  212,  185,  216,  332,  194,  234,  263,  236,
 /*  4040 */   298,   30,  332,  235,   66,  332,   40,   34,  295,  241,
 /*  4050 */   240,  157,  125,  332,  237,  238,  239,  332,  332,  332,
 /*  4060 */   332,    7,  332,   25,   35,   23,   36,   32,   49,   48,
 /*  4070 */    30,  311,  332,   66,  332,   40,   34,  332,  332,  332,
 /*  4080 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  4090 */   332,  197,   25,   35,   23,   36,   32,   49,   48,   30,
 /*  4100 */   311,  332,   66,  332,   40,   34,  332,  332,  332,  332,
 /*  4110 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  4120 */   203,   25,   35,   23,   36,   32,   49,   48,   30,  311,
 /*  4130 */   332,   66,  332,   40,   34,  332,  332,  332,  332,  332,
 /*  4140 */   332,  332,  332,  332,  332,  332,  332,  332,   73,  111,
 /*  4150 */    25,   35,   23,   36,   32,   49,   48,  332,  311,  234,
 /*  4160 */   263,  236,  298,  332,  332,  235,  332,  332,  332,  332,
 /*  4170 */   332,  241,  240,  332,  301,  332,  237,  238,  239,  332,
 /*  4180 */   288,  332,   30,  332,  332,   66,  332,   40,   34,  332,
 /*  4190 */   332,  332,  332,  332,  332,  143,  332,  332,  332,  332,
 /*  4200 */   332,  332,  123,  332,   25,   35,   23,   36,   32,   49,
 /*  4210 */    48,   30,  311,  332,   66,  332,   40,   34,  332,  332,
 /*  4220 */   332,  332,  332,  332,  332,  332,  332,  244,  267,  264,
 /*  4230 */   259,  260,  261,   25,   35,   23,   36,   32,   49,   48,
 /*  4240 */    30,  311,  332,   66,   60,   40,   34,  293,  150,    4,
 /*  4250 */   332,  332,  332,  332,  332,    8,  332,  332,  332,  332,
 /*  4260 */   332,  200,   25,   35,   23,   36,   32,   49,   48,  332,
 /*  4270 */   311,  332,  110,  111,  296,  332,  332,  332,  332,  332,
 /*  4280 */   332,  332,  332,  234,  263,  236,  298,  332,  332,  235,
 /*  4290 */   332,  332,   72,  111,  332,  241,  240,  332,  161,  332,
 /*  4300 */   237,  238,  239,  234,  263,  236,  298,  332,  379,  235,
 /*  4310 */   379,  379,  379,  332,  332,  241,  240,  332,  301,  332,
 /*  4320 */   237,  238,  239,  332,  110,  111,  332,  332,  379,  332,
 /*  4330 */   379,  379,  332,  332,  379,  234,  263,  236,  298,   30,
 /*  4340 */   332,  235,   66,  332,   40,   34,  332,  241,  240,  332,
 /*  4350 */   160,  332,  237,  238,  239,  332,  332,  332,  332,  332,
 /*  4360 */   332,   25,   35,   23,   36,   32,   49,   48,   66,  311,
 /*  4370 */    40,   34,  332,  332,  332,  332,  332,  332,   39,  332,
 /*  4380 */   332,  332,  332,  332,  332,  332,  332,   25,   35,   23,
 /*  4390 */    36,   32,   49,   48,   66,  311,   40,   34,  332,  332,
 /*  4400 */   332,  332,  332,  332,   29,  332,  332,  332,  332,   66,
 /*  4410 */   332,   40,   34,   25,   35,   23,   36,   32,   49,   48,
 /*  4420 */   332,  311,  332,  332,  332,  332,  332,  332,   25,   35,
 /*  4430 */    23,   36,   32,   49,   48,  332,  311,   59,    7,  332,
 /*  4440 */   332,  332,  332,  332,  332,  195,  332,  332,  332,  332,
 /*  4450 */   332,  379,  332,  379,  379,  379,  332,  196,  199,  332,
 /*  4460 */   332,  212,  185,  216,  332,  332,  332,  332,  332,  332,
 /*  4470 */   332,  379,  332,  379,  379,  332,  332,  379,  332,  332,
 /*  4480 */   141,
    );
    static public $yy_lookahead = array(
 /*     0 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    10 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*    20 */    95,   96,   97,   98,   50,   51,  101,   29,  103,   31,
 /*    30 */    13,   14,  107,  108,   77,  110,    3,  112,  113,  114,
 /*    40 */    23,   24,   25,   26,   27,   28,   29,  126,   31,  128,
 /*    50 */   129,  126,  127,  128,  129,   22,   54,   39,   56,   57,
 /*    60 */   135,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*    70 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*    80 */    98,    1,   21,  101,    4,  103,    6,    7,   70,  107,
 /*    90 */   108,  109,  110,   41,  112,  113,  114,   24,   25,   26,
 /*   100 */    27,   28,   29,  121,   31,  123,   73,   15,  126,  127,
 /*   110 */   128,  129,   27,   28,   29,   22,   31,  135,   79,   80,
 /*   120 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   130 */    91,   92,   93,   94,   95,   96,   97,   98,   67,   68,
 /*   140 */   101,   41,  103,   52,   95,   53,  107,  108,  109,  110,
 /*   150 */   101,  112,  113,  114,  105,  106,  107,  108,   58,   95,
 /*   160 */   121,   49,  123,   63,   52,  126,  127,  128,  129,   11,
 /*   170 */    12,  107,  108,  104,  135,   79,   80,   81,   82,   83,
 /*   180 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   190 */    94,   95,   96,   97,   98,  131,  132,  101,  126,  103,
 /*   200 */   128,  129,    2,  107,  108,  109,  110,   77,  112,  113,
 /*   210 */   114,   22,   25,   26,   27,   28,   29,  121,   31,  123,
 /*   220 */    77,   21,  126,  127,  128,  129,   77,   77,   39,   77,
 /*   230 */    22,  135,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   240 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   250 */    97,   98,  133,  134,  101,   21,  103,  133,  134,   77,
 /*   260 */   107,  108,  109,  110,    3,  112,  113,  114,   26,   27,
 /*   270 */    28,   29,   95,   31,  121,  126,  123,  128,  129,  126,
 /*   280 */   127,  128,  129,   77,  107,  108,   52,   67,  135,   79,
 /*   290 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   300 */    90,   91,   92,   93,   94,   95,   96,   97,   98,  132,
 /*   310 */    70,  101,   17,  103,   39,   20,   39,  107,  108,  109,
 /*   320 */   110,   15,  112,  113,  114,   22,   21,   32,   33,   16,
 /*   330 */    77,  121,  126,  123,  128,  129,  126,  127,  128,  129,
 /*   340 */    35,   52,   39,   95,   39,  135,   79,   80,   81,   82,
 /*   350 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   360 */    93,   94,   95,   96,   97,   98,   39,   55,  101,   41,
 /*   370 */   103,   95,  120,   34,  107,  108,  103,  110,   95,  112,
 /*   380 */   113,  114,  125,  116,  117,   77,   58,   77,  130,  122,
 /*   390 */    62,   63,   73,  126,  127,  128,  129,   31,   77,   77,
 /*   400 */   134,  115,  135,   79,   80,   81,   82,   83,   84,   85,
 /*   410 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   420 */    96,   97,   98,   77,  115,  101,   52,  103,   95,  104,
 /*   430 */    13,  107,  108,  109,  110,  120,  112,  113,  114,   21,
 /*   440 */    23,   24,   25,   26,   27,   28,   29,  123,   31,  120,
 /*   450 */   126,  127,  128,  129,  104,   95,  104,   39,   76,  135,
 /*   460 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   470 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   480 */    98,   77,   64,  101,  104,  103,   21,   22,   14,  107,
 /*   490 */   108,  104,  110,  136,  112,  113,  114,   23,   24,   25,
 /*   500 */    26,   27,   28,   29,   39,   31,  136,  136,  126,  127,
 /*   510 */   128,  129,  136,  136,  136,  136,  136,  135,   79,   80,
 /*   520 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   530 */    91,   92,   93,   94,   95,   96,   97,   98,  136,  136,
 /*   540 */   101,  136,  103,  136,  136,  136,  107,  108,  109,  110,
 /*   550 */   136,  112,  113,  114,  136,   23,   24,   25,   26,   27,
 /*   560 */    28,   29,  123,   31,  136,  126,  127,  128,  129,  136,
 /*   570 */   136,  136,  136,   76,  135,   78,   79,   80,   81,   82,
 /*   580 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   590 */    93,   94,   95,   96,   97,   98,   77,  136,  101,  136,
 /*   600 */   103,   21,   22,   14,  107,  108,  136,  110,  136,  112,
 /*   610 */   113,  114,   23,   24,   25,   26,   27,   28,   29,   39,
 /*   620 */    31,  136,  136,  126,  127,  128,  129,  136,  136,  111,
 /*   630 */   111,  136,  135,  115,  115,  136,  136,  119,  119,   76,
 /*   640 */   136,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   650 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   660 */    97,   98,  136,   77,  101,  136,  103,  136,  136,   21,
 /*   670 */   107,  108,  136,  110,  136,  112,  113,  114,    2,  136,
 /*   680 */     4,  136,    6,    7,    8,    9,   10,   39,  136,  126,
 /*   690 */   127,  128,  129,  136,   18,   19,  136,  111,  135,  136,
 /*   700 */    52,  115,  136,   27,   28,  119,   30,  122,   32,   33,
 /*   710 */   136,  126,   64,  128,  129,  136,   40,   41,   42,   43,
 /*   720 */    44,   45,   46,   47,   48,  136,   50,   51,  111,   53,
 /*   730 */   136,  136,  115,  136,   58,  136,  119,   61,   62,   63,
 /*   740 */   122,   65,   66,  136,  126,   69,  128,  129,   72,   77,
 /*   750 */   136,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   760 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   770 */    98,   21,   22,  101,  136,  103,    3,  136,  136,  107,
 /*   780 */   108,   95,  110,  136,  112,  113,  114,  101,  102,   39,
 /*   790 */   136,  105,  106,  107,  108,   22,  136,  136,  126,  127,
 /*   800 */   128,  129,  136,  136,  136,  136,  136,  135,   78,   79,
 /*   810 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   820 */    90,   91,   92,   93,   94,   95,   96,   97,   98,  136,
 /*   830 */   136,  101,  136,  103,  136,   83,  136,  107,  108,  136,
 /*   840 */   110,  136,  112,  113,  114,  136,   73,   95,   96,  136,
 /*   850 */   136,   99,  100,  101,  136,  136,  126,  127,  128,  129,
 /*   860 */   136,  136,  136,  136,  136,  135,   79,   80,   81,   82,
 /*   870 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   880 */    93,   94,   95,   96,   97,   98,  136,   21,  101,  136,
 /*   890 */   103,  136,  136,  136,  107,  108,  136,  110,  136,  112,
 /*   900 */   113,  114,    2,  136,    4,   39,    6,    7,    8,    9,
 /*   910 */    10,  124,  136,  126,  127,  128,  129,  136,   18,   19,
 /*   920 */   136,   21,  135,  136,  136,   59,  136,   27,   28,  136,
 /*   930 */    30,  136,   32,   33,  136,   35,  136,  136,  136,  136,
 /*   940 */    40,   41,   42,   43,   44,   45,   46,   47,   48,  136,
 /*   950 */    50,   51,   95,   41,   42,   43,   41,  136,   58,   47,
 /*   960 */   136,   61,   62,   63,  107,  108,   66,  136,  136,   69,
 /*   970 */   113,  136,   72,   58,   62,    2,  136,    4,   63,    6,
 /*   980 */     7,    8,    9,   10,  136,  136,   71,  136,  131,  132,
 /*   990 */   136,   18,   19,  136,   21,  136,  136,  136,  136,  136,
 /*  1000 */    27,   28,  136,   30,  136,   32,   33,  136,  136,  136,
 /*  1010 */   136,  136,  136,   40,   41,   42,   43,   44,   45,   46,
 /*  1020 */    47,   48,  136,   50,   51,  136,  136,  136,  136,  136,
 /*  1030 */   136,   58,  136,  136,   61,   62,   63,   64,  136,   66,
 /*  1040 */   136,  136,   69,  136,  136,   72,   79,   80,   81,   82,
 /*  1050 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1060 */    93,   94,   95,   96,   97,   98,  136,  136,  101,  136,
 /*  1070 */   103,  136,  136,  136,  107,  108,  136,  110,  136,  112,
 /*  1080 */   113,  114,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  1090 */   136,  136,  136,  126,  127,  128,  129,  136,  136,  136,
 /*  1100 */   136,  136,  135,   79,   80,   81,   82,   83,   84,   85,
 /*  1110 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  1120 */    96,   97,   98,  136,  136,  101,  136,  103,  136,   83,
 /*  1130 */   136,  107,  108,  136,  110,  136,  112,  113,  114,  136,
 /*  1140 */   136,   95,   96,  136,  136,   99,  100,  101,  136,  136,
 /*  1150 */   126,  127,  128,  129,  136,  136,  136,  136,  136,  135,
 /*  1160 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  1170 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  1180 */   136,  136,  101,  136,  103,  136,  136,  136,  107,  108,
 /*  1190 */   136,  110,  136,  112,  113,  114,  136,  136,  136,  136,
 /*  1200 */   136,  136,  136,  136,  136,  136,  136,  126,  127,  128,
 /*  1210 */   129,  136,  136,  136,  136,  136,  135,   79,   80,   81,
 /*  1220 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  1230 */    92,   93,   94,   95,   96,   97,   98,  136,  136,  101,
 /*  1240 */   136,  103,  136,  136,  136,  107,  108,  136,  110,  136,
 /*  1250 */   112,  113,  114,  136,  136,  136,  136,  136,  136,  136,
 /*  1260 */   136,  136,  136,  136,  126,  127,  128,  129,  136,  136,
 /*  1270 */   136,  136,  136,  135,   79,   80,   81,   82,   83,   84,
 /*  1280 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  1290 */    95,   96,   97,   98,  136,  136,  101,  136,  103,  136,
 /*  1300 */   136,  136,  107,  108,  136,  110,  136,  112,  113,  114,
 /*  1310 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  1320 */   136,  126,  127,  128,  129,  136,  136,  136,  136,  136,
 /*  1330 */   135,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1340 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  1350 */    98,  136,  136,  101,  136,  103,  136,  136,  136,  107,
 /*  1360 */   108,  136,  110,  136,  112,  113,  114,  136,  136,  136,
 /*  1370 */   136,  136,  136,  136,  136,  136,  136,  136,  126,  127,
 /*  1380 */   128,  129,  136,  136,  136,  136,  136,  135,   79,   80,
 /*  1390 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  1400 */    91,   92,   93,   94,   95,   96,   97,   98,  136,  136,
 /*  1410 */   101,  136,  103,  136,  136,  136,  107,  108,  136,  110,
 /*  1420 */   136,  112,  113,  114,  136,  136,  136,  136,  136,  136,
 /*  1430 */   136,  136,  136,  136,  136,  126,  127,  128,  129,  136,
 /*  1440 */   136,  136,  136,  136,  135,   79,   80,   81,   82,   83,
 /*  1450 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1460 */    94,   95,   96,   97,   98,  136,  136,  101,  136,  103,
 /*  1470 */   136,  136,  136,  107,  108,  136,  110,  136,  112,  113,
 /*  1480 */   114,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  1490 */   136,  136,  126,  127,  128,  129,  136,  136,  136,  136,
 /*  1500 */   136,  135,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  1510 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  1520 */    97,   98,  136,  136,  101,  136,  103,  136,  136,  136,
 /*  1530 */   107,  108,  136,  110,  136,  112,  113,  114,  136,  136,
 /*  1540 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  126,
 /*  1550 */   127,  128,  129,  136,  136,  136,  136,  136,  135,   79,
 /*  1560 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  1570 */    90,   91,   92,   93,   94,   95,   96,   97,   98,  136,
 /*  1580 */   136,  101,  136,  103,  136,  136,  136,  107,  108,  136,
 /*  1590 */   110,  136,  112,  113,  114,  136,  136,  136,  136,  136,
 /*  1600 */   136,  136,  136,  136,  136,  136,  126,  127,  128,  129,
 /*  1610 */   136,  136,  136,  136,  136,  135,   79,   80,   81,   82,
 /*  1620 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1630 */    93,   94,   95,   96,   97,   98,  136,  136,  101,  136,
 /*  1640 */   103,  136,  136,  136,  107,  108,  136,  110,  136,  112,
 /*  1650 */   113,  114,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  1660 */   136,  136,  136,  126,  127,  128,  129,  136,  136,  136,
 /*  1670 */   136,  136,  135,   79,   80,   81,   82,   83,   84,   85,
 /*  1680 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  1690 */    96,   97,   98,  136,  136,  101,  136,  103,  136,  136,
 /*  1700 */   136,  107,  108,  136,  110,  136,  112,  113,  114,  136,
 /*  1710 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  1720 */   126,  127,  128,  129,  136,  136,  136,  136,  136,  135,
 /*  1730 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  1740 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  1750 */   136,  136,  101,  136,  103,  136,  136,  136,  107,  108,
 /*  1760 */   136,  110,  136,  112,  113,  114,  136,  136,  136,  136,
 /*  1770 */   136,  136,  136,  136,  136,  136,  136,  126,  127,  128,
 /*  1780 */   129,  136,  136,  136,  136,  136,  135,   79,   80,   81,
 /*  1790 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  1800 */    92,   93,   94,   95,   96,   97,   98,  136,  136,  101,
 /*  1810 */   136,  103,  136,  136,  136,  107,  108,  136,  110,  136,
 /*  1820 */   112,  113,  114,  136,  136,  136,  136,  136,  136,  136,
 /*  1830 */   136,  136,  136,  136,  126,  127,  128,  129,  136,  136,
 /*  1840 */   136,  136,  136,  135,   79,   80,   81,   82,   83,   84,
 /*  1850 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  1860 */    95,   96,   97,   98,  136,  136,  101,  136,  103,  136,
 /*  1870 */   136,  136,  107,  108,  136,  110,  136,  112,  113,  114,
 /*  1880 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  1890 */   136,  126,  127,  128,  129,  136,  136,  136,  136,  136,
 /*  1900 */   135,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1910 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  1920 */    98,  136,  136,  101,  136,  103,  136,  136,  136,  107,
 /*  1930 */   108,  136,  110,  136,  112,  113,  114,  136,  136,  136,
 /*  1940 */   136,  136,  136,  136,  136,  136,  136,  136,  126,  127,
 /*  1950 */   128,  129,  136,  136,  136,  136,  136,  135,   79,   80,
 /*  1960 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  1970 */    91,   92,   93,   94,   95,   96,   97,   98,  136,  136,
 /*  1980 */   101,  136,  103,  136,  136,  136,  107,  108,  136,  110,
 /*  1990 */   136,  112,  113,  114,  136,  136,  136,  136,  136,  136,
 /*  2000 */   136,  136,  136,  136,  136,  126,  127,  128,  129,  136,
 /*  2010 */   136,  136,  136,  136,  135,   79,   80,   81,   82,   83,
 /*  2020 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  2030 */    94,   95,   96,   97,   98,  136,  136,  101,  136,  103,
 /*  2040 */   136,  136,  136,  107,  108,  136,  110,  136,  112,  113,
 /*  2050 */   114,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  2060 */   136,  136,  126,  127,  128,  129,  136,  136,  136,  136,
 /*  2070 */   136,  135,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  2080 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  2090 */    97,   98,  136,  136,  101,  136,  103,  136,  136,  136,
 /*  2100 */   107,  108,  136,  110,  136,  112,  113,  114,  136,  136,
 /*  2110 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  126,
 /*  2120 */   127,  128,  129,  136,  136,  136,  136,  136,  135,   79,
 /*  2130 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  2140 */    90,   91,   92,   93,   94,   95,   96,   97,   98,  136,
 /*  2150 */   136,  101,  136,  103,  136,  136,  136,  107,  108,  136,
 /*  2160 */   110,  136,  112,  113,  114,  136,  136,  136,  136,  136,
 /*  2170 */   136,  136,  136,  136,  136,  136,  126,  127,  128,  129,
 /*  2180 */   136,  136,  136,  136,  136,  135,   79,   80,   81,   82,
 /*  2190 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  2200 */    93,   94,   95,   96,   97,   98,  136,  136,  101,  136,
 /*  2210 */   103,  136,  136,  136,  107,  108,  136,  110,  136,  112,
 /*  2220 */   113,  114,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  2230 */   136,  136,  136,  126,  127,  128,  129,  136,  136,  136,
 /*  2240 */   136,  136,  135,   79,   80,   81,   82,   83,   84,   85,
 /*  2250 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  2260 */    96,   97,   98,  136,  136,  101,  136,  103,  136,  136,
 /*  2270 */   136,  107,  108,  136,  110,  136,  112,  113,  114,  136,
 /*  2280 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  2290 */   126,  127,  128,  129,  136,  136,  136,  136,  136,  135,
 /*  2300 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  2310 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  2320 */   136,  136,  101,  136,  103,  136,  136,  136,  107,  108,
 /*  2330 */   136,  110,  136,  112,  113,  114,  136,  136,  136,  136,
 /*  2340 */   136,  136,  136,  136,  136,  136,  136,  126,  127,  128,
 /*  2350 */   129,  136,  136,  136,  136,  136,  135,   79,   80,   81,
 /*  2360 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  2370 */    92,   93,   94,   95,   96,   97,   98,  136,  136,  101,
 /*  2380 */   136,  103,  136,  136,  136,  107,  108,  136,  110,  136,
 /*  2390 */   112,  113,  114,  136,  136,  136,  136,  136,  136,  136,
 /*  2400 */   136,  136,  136,  136,  126,  127,  128,  129,  136,  136,
 /*  2410 */   136,  136,  136,  135,   79,   80,   81,   82,   83,   84,
 /*  2420 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  2430 */    95,   96,   97,   98,  136,  136,  101,  136,  103,  136,
 /*  2440 */   136,  136,  107,  108,  136,  110,  136,  112,  113,  114,
 /*  2450 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  2460 */   136,  126,  127,  128,  129,  136,  136,  136,  136,  136,
 /*  2470 */   135,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  2480 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  2490 */    98,  136,  136,  101,  136,  103,  136,  136,  136,  107,
 /*  2500 */   108,  136,  110,  136,  112,  113,  114,  136,  136,  136,
 /*  2510 */   136,  136,  136,  136,  136,  136,  136,  136,  126,  127,
 /*  2520 */   128,  129,  136,  136,  136,  136,  136,  135,   79,   80,
 /*  2530 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  2540 */    91,   92,   93,   94,   95,   96,   97,   98,  136,  136,
 /*  2550 */   101,  136,  103,  136,  136,  136,  107,  108,  136,  110,
 /*  2560 */   136,  112,  113,  114,  136,  136,  136,  136,  136,  136,
 /*  2570 */   136,  136,  136,  136,  136,  126,  127,  128,  129,  136,
 /*  2580 */   136,  136,  136,  136,  135,   79,   80,   81,   82,   83,
 /*  2590 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  2600 */    94,   95,   96,   97,   98,  136,  136,  101,  136,  103,
 /*  2610 */   136,  136,  136,  107,  108,  136,  110,  136,  112,  113,
 /*  2620 */   114,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  2630 */   136,  136,  126,  127,  128,  129,  136,  136,  136,  136,
 /*  2640 */   136,  135,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  2650 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  2660 */    97,   98,  136,  136,  101,  136,  103,  136,  136,  136,
 /*  2670 */   107,  108,  136,  110,  136,  112,  113,  114,    2,  136,
 /*  2680 */     4,  136,    6,    7,    8,    9,   10,  136,  136,  126,
 /*  2690 */   127,  128,  129,  136,   18,   19,  136,   21,  135,  136,
 /*  2700 */   136,  136,  136,   27,   28,  136,   30,  136,   32,   33,
 /*  2710 */   136,  136,  136,  136,  136,  136,   40,   41,   42,   43,
 /*  2720 */    44,   45,   46,   47,   48,  136,   50,   51,  136,  136,
 /*  2730 */   136,  136,  136,  136,   58,  136,  136,   61,   62,   63,
 /*  2740 */   136,  136,   66,  136,  136,   69,  136,  136,   72,  136,
 /*  2750 */   136,    2,  136,    4,  136,    6,    7,    8,    9,   10,
 /*  2760 */   136,  136,  136,  136,  136,  136,  136,   18,   19,  136,
 /*  2770 */    21,  136,  136,  136,  136,  136,   27,   28,  136,   30,
 /*  2780 */   136,   32,   33,  136,  136,  136,  136,  136,  136,   40,
 /*  2790 */    41,   42,   43,   44,   45,   46,   47,   48,  136,   50,
 /*  2800 */    51,  136,  136,  136,  136,  136,  136,   58,  136,  136,
 /*  2810 */    61,   62,   63,  136,  136,   66,  136,  136,   69,  136,
 /*  2820 */   136,   72,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  2830 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  2840 */    97,   98,  136,  136,  101,  136,  103,  136,  136,  136,
 /*  2850 */   107,  108,  136,  110,  136,  112,  113,  114,    2,  136,
 /*  2860 */     4,  136,    6,    7,    8,    9,   10,  136,  136,  126,
 /*  2870 */   127,  128,  129,  136,   18,   19,  136,   21,  135,  136,
 /*  2880 */   136,  136,  136,   27,   28,  136,   30,  136,   32,   33,
 /*  2890 */   136,  136,  136,  136,  136,  136,   40,   41,   42,   43,
 /*  2900 */    44,   45,   46,   47,   48,  136,   50,   51,  136,  136,
 /*  2910 */   136,  136,  136,  136,   58,  136,  136,   61,   62,   63,
 /*  2920 */   136,  136,   66,  136,  136,   69,  136,  136,   72,  136,
 /*  2930 */   136,    2,  136,    4,  136,    6,    7,    8,    9,   10,
 /*  2940 */   136,  136,  136,  136,  136,  136,  136,   18,   19,  136,
 /*  2950 */    21,  136,  136,  136,  136,  136,   27,   28,  136,   30,
 /*  2960 */   136,   32,   33,  136,  136,  136,  136,  136,  136,   40,
 /*  2970 */    41,   42,   43,   44,   45,   46,   47,   48,  136,   50,
 /*  2980 */    51,  136,  136,  136,  136,  136,  136,   58,  136,  136,
 /*  2990 */    61,   62,   63,  136,  136,   66,  136,  136,   69,  136,
 /*  3000 */   136,   72,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  3010 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  3020 */    97,   98,  136,  136,  101,  136,  103,  136,  136,  136,
 /*  3030 */   107,  108,  136,  110,  136,  112,  113,  114,  136,  136,
 /*  3040 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  126,
 /*  3050 */   127,  128,  129,  136,  136,  136,  136,  136,  135,   79,
 /*  3060 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  3070 */    90,   91,   92,   93,   94,   95,   96,   97,   98,  136,
 /*  3080 */   136,  101,  136,  103,  136,  136,  136,  107,  108,  136,
 /*  3090 */   110,  136,  112,  113,  114,    2,  136,    4,  136,    6,
 /*  3100 */     7,    8,    9,   10,  136,  136,  126,  127,  128,  129,
 /*  3110 */   136,   18,   19,  136,   21,  135,  136,  136,  136,  136,
 /*  3120 */    27,   28,  136,   30,  136,   32,   33,  136,  136,  136,
 /*  3130 */   136,  136,  136,   40,   41,   42,   43,   44,   45,   46,
 /*  3140 */    47,   48,  136,   50,   51,  136,  136,  136,  136,  136,
 /*  3150 */   136,   58,  136,  136,   61,   62,   63,  136,  136,   66,
 /*  3160 */   136,  136,   69,  136,  136,   72,  136,  136,    2,  136,
 /*  3170 */     4,  136,    6,    7,    8,    9,   10,  136,  136,  136,
 /*  3180 */   136,  136,  136,  136,   18,   19,  136,  136,   22,  136,
 /*  3190 */   136,  136,  136,   27,   28,  136,   30,  136,   32,   33,
 /*  3200 */   136,  136,  136,  136,  136,  136,   40,   41,   42,   43,
 /*  3210 */    44,   45,   46,   47,   48,  136,   50,   51,  136,  136,
 /*  3220 */   136,  136,  136,  136,   58,  136,  136,   61,   62,   63,
 /*  3230 */   136,  136,   66,  136,  136,   69,  136,  136,   72,  136,
 /*  3240 */   136,    2,  136,    4,  136,    6,    7,    8,    9,   10,
 /*  3250 */   136,  136,  136,  136,  136,  136,  136,   18,   19,  136,
 /*  3260 */    21,  136,  136,  136,  136,  136,   27,   28,  136,   30,
 /*  3270 */   136,   32,   33,  136,  136,  136,  136,  136,  136,   40,
 /*  3280 */    41,   42,   43,   44,   45,   46,   47,   48,  136,   50,
 /*  3290 */    51,  136,  136,  136,  136,  136,  136,   58,  136,  136,
 /*  3300 */    61,   62,   63,  136,  136,   66,  136,  136,   69,  136,
 /*  3310 */   136,   72,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  3320 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  3330 */    97,   98,  136,  136,  101,  136,  103,  136,  136,  136,
 /*  3340 */   107,  108,  136,  110,  136,  112,  113,  114,  136,  136,
 /*  3350 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  126,
 /*  3360 */   127,  128,  129,  136,  136,  136,  136,  136,  135,   79,
 /*  3370 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  3380 */    90,   91,   92,   93,   94,   95,   96,   97,   98,  136,
 /*  3390 */   136,  101,  136,  103,  136,  136,  136,  107,  108,  136,
 /*  3400 */   110,  136,  112,  113,  114,  136,  136,  136,  136,  136,
 /*  3410 */   136,  136,  136,  136,  136,  136,  126,  127,  128,  129,
 /*  3420 */   136,  136,  136,  136,  136,  135,   79,   80,   81,   82,
 /*  3430 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  3440 */    93,   94,   95,   96,   97,   98,  136,  136,  101,  136,
 /*  3450 */   103,  136,  136,  136,  107,  108,  136,  110,  136,  112,
 /*  3460 */   113,  114,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  3470 */   136,  136,  136,  126,  127,  128,  129,  136,  136,  136,
 /*  3480 */   136,  136,  135,   79,   80,   81,   82,   83,   84,   85,
 /*  3490 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  3500 */    96,   97,   98,  136,  136,  101,  136,  103,  136,  136,
 /*  3510 */   136,  107,  108,  136,  110,  136,  112,  113,  114,  136,
 /*  3520 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  3530 */   126,  127,  128,  129,  136,  136,  136,  136,  136,  135,
 /*  3540 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  3550 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  3560 */   136,  136,  101,  136,  103,  136,  136,  136,  107,  108,
 /*  3570 */   136,  110,  136,  112,  113,  114,  136,  136,  136,  136,
 /*  3580 */   136,  136,  136,  136,  136,  136,  136,  126,  127,  128,
 /*  3590 */   129,  136,  136,  136,  136,  136,  135,   79,   80,   81,
 /*  3600 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  3610 */    92,   93,   94,   95,   96,   97,   98,  136,  136,  101,
 /*  3620 */   136,  103,  136,  136,  136,  107,  108,  136,  110,  136,
 /*  3630 */   112,  113,  114,    2,  136,    4,  136,    6,    7,    8,
 /*  3640 */     9,   10,  136,  136,  126,  127,  128,  129,  136,   18,
 /*  3650 */    19,  136,   21,  135,  136,  136,  136,  136,   27,   28,
 /*  3660 */   136,   30,  136,   32,   33,  136,  136,  136,  136,  136,
 /*  3670 */   136,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*  3680 */   136,   50,   51,  136,  136,  136,  136,  136,  136,   58,
 /*  3690 */   136,  136,   61,   62,   63,  136,  136,   66,  136,  136,
 /*  3700 */    69,  136,  136,   72,  136,   79,   80,   81,   82,   83,
 /*  3710 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  3720 */    94,   95,   96,   97,   98,  136,  136,  101,  136,  103,
 /*  3730 */   136,  136,  136,  107,  108,  136,  110,  136,  112,  113,
 /*  3740 */   114,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  3750 */   136,  136,  126,  127,  128,  129,  136,  136,  136,  136,
 /*  3760 */   136,  135,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  3770 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  3780 */    97,   98,  136,  136,  101,  136,  103,  136,  136,  136,
 /*  3790 */   107,  108,  136,  110,  136,  112,  113,  114,    2,  136,
 /*  3800 */     4,  136,    6,    7,    8,    9,   10,  136,  136,  126,
 /*  3810 */   127,  128,  129,  136,   18,   19,  136,  136,  135,  136,
 /*  3820 */   136,  136,  136,   27,   28,  136,   30,  136,   32,   33,
 /*  3830 */   136,  136,  136,  136,  136,  136,   40,   41,   42,   43,
 /*  3840 */    44,   45,   46,   47,   48,  136,   50,   51,  136,   36,
 /*  3850 */    37,   38,  136,  136,   58,  136,  136,   61,   62,   63,
 /*  3860 */   136,  136,   66,  136,  136,   69,  136,   54,   72,   56,
 /*  3870 */    57,    2,   34,   60,   36,   37,   38,    8,    9,   10,
 /*  3880 */   136,  136,  136,  136,  136,  136,  136,   18,   19,  136,
 /*  3890 */   136,  136,   54,  136,   56,   57,   27,   28,   60,   30,
 /*  3900 */   136,   32,   33,  136,  136,  136,  136,  136,  136,   40,
 /*  3910 */    41,   42,   43,   44,   45,   46,   47,   48,  136,   50,
 /*  3920 */    51,  136,    9,  136,  136,  136,  136,   58,  136,  136,
 /*  3930 */    61,   62,   63,   20,   21,   66,  136,  136,   69,  136,
 /*  3940 */     1,   72,  136,    4,  136,    6,    7,  136,  136,  136,
 /*  3950 */   136,  136,  136,  136,   41,   42,   43,   44,   45,   46,
 /*  3960 */   136,  136,   23,   24,   25,   26,   27,   28,   29,  136,
 /*  3970 */    31,   58,  136,  136,   61,   62,   63,  136,  136,  136,
 /*  3980 */   136,  136,   69,  136,    1,   21,  136,    4,  136,    6,
 /*  3990 */     7,  136,   53,  136,  136,  136,  136,  136,   34,  136,
 /*  4000 */    36,   37,   38,  136,   65,  136,   23,   24,   25,   26,
 /*  4010 */    27,   28,   29,  136,   31,  136,   83,  136,   54,   77,
 /*  4020 */    56,   57,  136,  136,   60,  136,   84,   85,   95,   96,
 /*  4030 */   136,  136,   99,  100,  101,  136,   53,   95,   96,   97,
 /*  4040 */    98,    1,  136,  101,    4,  136,    6,    7,   65,  107,
 /*  4050 */   108,  118,  110,  136,  112,  113,  114,  136,  136,  136,
 /*  4060 */   136,   21,  136,   23,   24,   25,   26,   27,   28,   29,
 /*  4070 */     1,   31,  136,    4,  136,    6,    7,  136,  136,  136,
 /*  4080 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  4090 */   136,   22,   23,   24,   25,   26,   27,   28,   29,    1,
 /*  4100 */    31,  136,    4,  136,    6,    7,  136,  136,  136,  136,
 /*  4110 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*  4120 */    22,   23,   24,   25,   26,   27,   28,   29,    1,   31,
 /*  4130 */   136,    4,  136,    6,    7,  136,  136,  136,  136,  136,
 /*  4140 */   136,  136,  136,  136,  136,  136,  136,  136,   84,   85,
 /*  4150 */    23,   24,   25,   26,   27,   28,   29,  136,   31,   95,
 /*  4160 */    96,   97,   98,  136,  136,  101,  136,  136,  136,  136,
 /*  4170 */   136,  107,  108,  136,  110,  136,  112,  113,  114,  136,
 /*  4180 */    53,  136,    1,  136,  136,    4,  136,    6,    7,  136,
 /*  4190 */   136,  136,  136,  136,  136,    9,  136,  136,  136,  136,
 /*  4200 */   136,  136,   21,  136,   23,   24,   25,   26,   27,   28,
 /*  4210 */    29,    1,   31,  136,    4,  136,    6,    7,  136,  136,
 /*  4220 */   136,  136,  136,  136,  136,  136,  136,   41,   42,   43,
 /*  4230 */    44,   45,   46,   23,   24,   25,   26,   27,   28,   29,
 /*  4240 */     1,   31,  136,    4,   58,    6,    7,   61,   62,   63,
 /*  4250 */   136,  136,  136,  136,  136,   69,  136,  136,  136,  136,
 /*  4260 */   136,   22,   23,   24,   25,   26,   27,   28,   29,  136,
 /*  4270 */    31,  136,   84,   85,   64,  136,  136,  136,  136,  136,
 /*  4280 */   136,  136,  136,   95,   96,   97,   98,  136,  136,  101,
 /*  4290 */   136,  136,   84,   85,  136,  107,  108,  136,  110,  136,
 /*  4300 */   112,  113,  114,   95,   96,   97,   98,  136,   34,  101,
 /*  4310 */    36,   37,   38,  136,  136,  107,  108,  136,  110,  136,
 /*  4320 */   112,  113,  114,  136,   84,   85,  136,  136,   54,  136,
 /*  4330 */    56,   57,  136,  136,   60,   95,   96,   97,   98,    1,
 /*  4340 */   136,  101,    4,  136,    6,    7,  136,  107,  108,  136,
 /*  4350 */   110,  136,  112,  113,  114,  136,  136,  136,  136,  136,
 /*  4360 */   136,   23,   24,   25,   26,   27,   28,   29,    4,   31,
 /*  4370 */     6,    7,  136,  136,  136,  136,  136,  136,   14,  136,
 /*  4380 */   136,  136,  136,  136,  136,  136,  136,   23,   24,   25,
 /*  4390 */    26,   27,   28,   29,    4,   31,    6,    7,  136,  136,
 /*  4400 */   136,  136,  136,  136,   14,  136,  136,  136,  136,    4,
 /*  4410 */   136,    6,    7,   23,   24,   25,   26,   27,   28,   29,
 /*  4420 */   136,   31,  136,  136,  136,  136,  136,  136,   23,   24,
 /*  4430 */    25,   26,   27,   28,   29,  136,   31,   20,   21,  136,
 /*  4440 */   136,  136,  136,  136,  136,   83,  136,  136,  136,  136,
 /*  4450 */   136,   34,  136,   36,   37,   38,  136,   95,   96,  136,
 /*  4460 */   136,   99,  100,  101,  136,  136,  136,  136,  136,  136,
 /*  4470 */   136,   54,  136,   56,   57,  136,  136,   60,  136,  136,
 /*  4480 */   118,
);
    const YY_SHIFT_USE_DFLT = -27;
    const YY_SHIFT_MAX = 186;
    static public $yy_shift_ofst = array(
 /*     0 */  2676,  676,  973,  900,  973, 3093, 3093, 3166, 3239, 3796,
 /*    10 */  3796, 3796, 2676, 3796, 3796, 2749, 2929, 2856, 3631, 3796,
 /*    20 */  3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796,
 /*    30 */  3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796,
 /*    40 */  3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796, 3796,
 /*    50 */  3796, 3796, 3796, 3796, 3869, 3913, 4186, 4186, 4186, 4186,
 /*    60 */   912,  912,  328,  912,  912,  328,  915,  100, 3939, 3983,
 /*    70 */  4040, 4040, 3964, 3964,  100, 4239, 4069, 4210, 4098, 4181,
 /*    80 */  4127, 4338, 4338, 4338, 4338, 4338, 4338, 4390, 4338, 4338,
 /*    90 */  4364, 4338, 4405, 4405, 4405,   17,  417,  589,  474,  532,
 /*   100 */   532,  532, 3838,  532,  532, 3838,  532,  532,  532,   73,
 /*   110 */  3813, 3813,  187,  242,   85,   80,   80,   -2,   -2,   -2,
 /*   120 */    -2,  366,  366,  319,  319, 4417,    2,  773,    2,   33,
 /*   130 */   200,  234,  158,   71,  -26,  339,   52,   52,   61,   61,
 /*   140 */   374,   91,  339,  339,  374,  374,   52,  374,   52,   61,
 /*   150 */    52,   61,   61,   61,   61,   61,   52,   91,   61,   61,
 /*   160 */  4274, 4274,  295,  648,  580,  866,  750,  418,  465,  305,
 /*   170 */   112,   18,  303,   92,  189,   93,  289,  327,  208,  240,
 /*   180 */   312,  275,  277,  220,  261,  313,  306,
);
    const YY_REDUCE_USE_DFLT = -80;
    const YY_REDUCE_MAX = 159;
    static public $yy_reduce_ofst = array(
 /*     0 */   -75,  267,  210,  -18,   39,  153,   96,  563,  382,  497,
 /*    10 */   439,  324,  672,  730,  787, 2743, 3290, 3233, 3518, 3404,
 /*    20 */  3347, 3683, 3626, 2107, 1366, 1024, 1594, 1423, 1309, 1252,
 /*    30 */  1138, 1195, 2449, 2221, 2278, 2335, 1708, 2050, 1765, 1879,
 /*    40 */  1993, 1936, 1822, 2392, 2164, 1651,  967, 1480, 1537, 1081,
 /*    50 */  3461, 2506, 2563, 2923, 2980, 3942, 4188, 4208, 4240, 4064,
 /*    60 */  4362, 3933,  686,  752, 1046,   49,  857,   64,  585,  618,
 /*    70 */   149,  206,  586,  519,  177,  -79,  -79,  -79,  -79,  -79,
 /*    80 */   -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,
 /*    90 */   -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,  -79,
 /*   100 */   -79,  -79,  617,  -79,  -79,  518,  -79,  -79,  -79,  -79,
 /*   110 */   617,  518,  -79,  -79,  -79,   72,   72,  -79,  -79,  -79,
 /*   120 */   -79,  -79,  -79,  119,  124,  321,  286,  266,  309,  266,
 /*   130 */   322,  310,  258,  257,  273,  252,  283,  248,  308,  346,
 /*   140 */   387,  380,  329,  315,  325,  350,  360,  352,  333,  404,
 /*   150 */   248,  143,  150,  152,  130,  -43,  276,   69,  182,  253,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 1 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 53, 58, 61, 62, 63, 65, 66, 69, 72, ),
        /* 2 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 64, 66, 69, 72, ),
        /* 3 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 4 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 64, 66, 69, 72, ),
        /* 5 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 6 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 7 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 22, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 8 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 9 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 10 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 11 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 12 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 13 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 14 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 15 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 16 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 17 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 18 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 21, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 19 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 20 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 21 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 22 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 23 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 24 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 25 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 26 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 27 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 28 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 29 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 30 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 31 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 32 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 33 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 34 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 35 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 36 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 37 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 38 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 39 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 40 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 41 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 42 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 43 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 44 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 45 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 46 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 47 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 48 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 49 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 50 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 51 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 52 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 53 */ array(2, 4, 6, 7, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 54 */ array(2, 8, 9, 10, 18, 19, 27, 28, 30, 32, 33, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 58, 61, 62, 63, 66, 69, 72, ),
        /* 55 */ array(9, 20, 21, 41, 42, 43, 44, 45, 46, 58, 61, 62, 63, 69, ),
        /* 56 */ array(9, 41, 42, 43, 44, 45, 46, 58, 61, 62, 63, 69, ),
        /* 57 */ array(9, 41, 42, 43, 44, 45, 46, 58, 61, 62, 63, 69, ),
        /* 58 */ array(9, 41, 42, 43, 44, 45, 46, 58, 61, 62, 63, 69, ),
        /* 59 */ array(9, 41, 42, 43, 44, 45, 46, 58, 61, 62, 63, 69, ),
        /* 60 */ array(41, 42, 43, 47, 62, ),
        /* 61 */ array(41, 42, 43, 47, 62, ),
        /* 62 */ array(41, 58, 62, 63, ),
        /* 63 */ array(41, 42, 43, 47, 62, ),
        /* 64 */ array(41, 42, 43, 47, 62, ),
        /* 65 */ array(41, 58, 62, 63, ),
        /* 66 */ array(41, 58, 63, 71, ),
        /* 67 */ array(41, 58, 63, ),
        /* 68 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, 53, 65, ),
        /* 69 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, 53, 65, ),
        /* 70 */ array(1, 4, 6, 7, 21, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 71 */ array(1, 4, 6, 7, 21, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 72 */ array(21, 34, 36, 37, 38, 54, 56, 57, 60, ),
        /* 73 */ array(21, 34, 36, 37, 38, 54, 56, 57, 60, ),
        /* 74 */ array(41, 58, 63, ),
        /* 75 */ array(1, 4, 6, 7, 22, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 76 */ array(1, 4, 6, 7, 22, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 77 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, 64, ),
        /* 78 */ array(1, 4, 6, 7, 22, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 79 */ array(1, 4, 6, 7, 21, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 80 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, 53, ),
        /* 81 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 82 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 83 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 84 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 85 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 86 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 87 */ array(4, 6, 7, 14, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 88 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 89 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 90 */ array(4, 6, 7, 14, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 91 */ array(1, 4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 92 */ array(4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 93 */ array(4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 94 */ array(4, 6, 7, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 95 */ array(13, 14, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 96 */ array(13, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 97 */ array(14, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 98 */ array(14, 23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 99 */ array(23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 100 */ array(23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 101 */ array(23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 102 */ array(34, 36, 37, 38, 54, 56, 57, 60, ),
        /* 103 */ array(23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 104 */ array(23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 105 */ array(34, 36, 37, 38, 54, 56, 57, 60, ),
        /* 106 */ array(23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 107 */ array(23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 108 */ array(23, 24, 25, 26, 27, 28, 29, 31, ),
        /* 109 */ array(24, 25, 26, 27, 28, 29, 31, ),
        /* 110 */ array(36, 37, 38, 54, 56, 57, 60, ),
        /* 111 */ array(36, 37, 38, 54, 56, 57, 60, ),
        /* 112 */ array(25, 26, 27, 28, 29, 31, ),
        /* 113 */ array(26, 27, 28, 29, 31, ),
        /* 114 */ array(27, 28, 29, 31, ),
        /* 115 */ array(1, 4, 6, 7, ),
        /* 116 */ array(1, 4, 6, 7, ),
        /* 117 */ array(29, 31, ),
        /* 118 */ array(29, 31, ),
        /* 119 */ array(29, 31, ),
        /* 120 */ array(29, 31, ),
        /* 121 */ array(31, ),
        /* 122 */ array(31, ),
        /* 123 */ array(73, ),
        /* 124 */ array(73, ),
        /* 125 */ array(20, 21, 34, 36, 37, 38, 54, 56, 57, 60, ),
        /* 126 */ array(54, 56, 57, ),
        /* 127 */ array(3, 22, 73, ),
        /* 128 */ array(54, 56, 57, ),
        /* 129 */ array(3, 22, 73, ),
        /* 130 */ array(2, 21, ),
        /* 131 */ array(21, 52, ),
        /* 132 */ array(11, 12, ),
        /* 133 */ array(67, 68, ),
        /* 134 */ array(50, 51, ),
        /* 135 */ array(34, ),
        /* 136 */ array(41, ),
        /* 137 */ array(41, ),
        /* 138 */ array(21, ),
        /* 139 */ array(21, ),
        /* 140 */ array(52, ),
        /* 141 */ array(52, ),
        /* 142 */ array(34, ),
        /* 143 */ array(34, ),
        /* 144 */ array(52, ),
        /* 145 */ array(52, ),
        /* 146 */ array(41, ),
        /* 147 */ array(52, ),
        /* 148 */ array(41, ),
        /* 149 */ array(21, ),
        /* 150 */ array(41, ),
        /* 151 */ array(21, ),
        /* 152 */ array(21, ),
        /* 153 */ array(21, ),
        /* 154 */ array(21, ),
        /* 155 */ array(21, ),
        /* 156 */ array(41, ),
        /* 157 */ array(52, ),
        /* 158 */ array(21, ),
        /* 159 */ array(21, ),
        /* 160 */ array(34, 36, 37, 38, 54, 56, 57, 60, ),
        /* 161 */ array(34, 36, 37, 38, 54, 56, 57, 60, ),
        /* 162 */ array(17, 20, 32, 33, ),
        /* 163 */ array(21, 39, 52, 64, ),
        /* 164 */ array(21, 22, 39, ),
        /* 165 */ array(21, 39, 59, ),
        /* 166 */ array(21, 22, 39, ),
        /* 167 */ array(21, 39, 64, ),
        /* 168 */ array(21, 22, 39, ),
        /* 169 */ array(21, 35, 39, ),
        /* 170 */ array(49, 52, ),
        /* 171 */ array(39, 70, ),
        /* 172 */ array(22, 39, ),
        /* 173 */ array(15, 53, ),
        /* 174 */ array(22, 39, ),
        /* 175 */ array(22, ),
        /* 176 */ array(52, ),
        /* 177 */ array(39, ),
        /* 178 */ array(22, ),
        /* 179 */ array(70, ),
        /* 180 */ array(55, ),
        /* 181 */ array(39, ),
        /* 182 */ array(39, ),
        /* 183 */ array(67, ),
        /* 184 */ array(3, ),
        /* 185 */ array(16, ),
        /* 186 */ array(15, ),
        /* 187 */ array(),
        /* 188 */ array(),
        /* 189 */ array(),
        /* 190 */ array(),
        /* 191 */ array(),
        /* 192 */ array(),
        /* 193 */ array(),
        /* 194 */ array(),
        /* 195 */ array(),
        /* 196 */ array(),
        /* 197 */ array(),
        /* 198 */ array(),
        /* 199 */ array(),
        /* 200 */ array(),
        /* 201 */ array(),
        /* 202 */ array(),
        /* 203 */ array(),
        /* 204 */ array(),
        /* 205 */ array(),
        /* 206 */ array(),
        /* 207 */ array(),
        /* 208 */ array(),
        /* 209 */ array(),
        /* 210 */ array(),
        /* 211 */ array(),
        /* 212 */ array(),
        /* 213 */ array(),
        /* 214 */ array(),
        /* 215 */ array(),
        /* 216 */ array(),
        /* 217 */ array(),
        /* 218 */ array(),
        /* 219 */ array(),
        /* 220 */ array(),
        /* 221 */ array(),
        /* 222 */ array(),
        /* 223 */ array(),
        /* 224 */ array(),
        /* 225 */ array(),
        /* 226 */ array(),
        /* 227 */ array(),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
);
    static public $yy_default = array(
 /*     0 */   314,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    10 */   508,  363,  508,  319,  508,  508,  508,  508,  508,  508,
 /*    20 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    30 */   508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
 /*    40 */   508,  508,  508,  508,  508,  508,  508,  428,  508,  508,
 /*    50 */   508,  508,  508,  508,  356,  403,  508,  508,  508,  508,
 /*    60 */   398,  398,  364,  508,  363,  508,  508,  508,  435,  395,
 /*    70 */   508,  508,  405,  409,  508,  508,  508,  508,  508,  508,
 /*    80 */   435,  438,  488,  369,  489,  427,  349,  449,  320,  429,
 /*    90 */   447,  437,  448,  450,  456,  469,  471,  473,  470,  475,
 /*   100 */   355,  346,  326,  472,  507,  327,  505,  474,  444,  503,
 /*   110 */   415,  415,  502,  504,  501,  321,  508,  499,  492,  498,
 /*   120 */   491,  500,  490,  508,  508,  407,  508,  508,  508,  508,
 /*   130 */   508,  508,  508,  439,  508,  508,  508,  508,  508,  508,
 /*   140 */   362,  362,  508,  413,  362,  362,  390,  362,  508,  508,
 /*   150 */   420,  508,  508,  508,  508,  508,  508,  362,  508,  508,
 /*   160 */   494,  493,  379,  425,  508,  508,  508,  508,  508,  508,
 /*   170 */   508,  508,  508,  367,  508,  508,  467,  482,  508,  508,
 /*   180 */   508,  508,  315,  440,  486,  348,  382,  337,  466,  358,
 /*   190 */   396,  316,  406,  397,  425,  351,  352,  506,  402,  353,
 /*   200 */   350,  460,  400,  347,  401,  417,  371,  373,  468,  372,
 /*   210 */   464,  318,  399,  368,  465,  366,  354,  462,  463,  365,
 /*   220 */   370,  418,  392,  324,  457,  359,  360,  361,  452,  338,
 /*   230 */   461,  357,  387,  317,  375,  378,  383,  384,  385,  386,
 /*   240 */   381,  380,  495,  496,  339,  458,  453,  329,  330,  331,
 /*   250 */   332,  328,  412,  389,  377,  393,  394,  333,  334,  343,
 /*   260 */   344,  345,  388,  342,  341,  335,  336,  340,  411,  416,
 /*   270 */   480,  478,  479,  455,  483,  487,  481,  391,  484,  485,
 /*   280 */   422,  323,  432,  430,  434,  433,  322,  423,  374,  431,
 /*   290 */   436,  477,  476,  419,  421,  424,  426,  414,  382,  408,
 /*   300 */   410,  379,  442,  441,  451,  454,  325,  459,  446,  445,
 /*   310 */   443,  497,  376,  404,
);
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    self::YYNOCODE      is a number which corresponds
**                        to no legal terminal or nonterminal number.  This
**                        number is used to fill in empty slots of the hash 
**                        table.
**    self::YYFALLBACK    If defined, this indicates that one or more tokens
**                        have fall-back values which should be used if the
**                        original value of the token will not parse.
**    self::YYSTACKDEPTH  is the maximum depth of the parser's stack.
**    self::YYNSTATE      the combined number of states.
**    self::YYNRULE       the number of rules in the grammar
**    self::YYERRORSYMBOL is the code number of the error symbol.  If not
**                        defined, then do no error processing.
*/
    const YYNOCODE = 137;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 314;
    const YYNRULE = 194;
    const YYERRORSYMBOL = 74;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    /** The next table maps tokens into fallback tokens.  If a construct
     * like the following:
     * 
     *      %fallback ID X Y Z.
     *
     * appears in the grammer, then ID becomes a fallback token for X, Y,
     * and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
     * but it does not parse, the type of the token is changed to ID and
     * the parse is retried before an error is thrown.
     */
    static public $yyFallback = array(
    );
    /**
     * Turn parser tracing on by giving a stream to which to write the trace
     * and a prompt to preface each trace message.  Tracing is turned off
     * by making either argument NULL 
     *
     * Inputs:
     * 
     * - A stream resource to which trace output should be written.
     *   If NULL, then tracing is turned off.
     * - A prefix string written at the beginning of every
     *   line of trace output.  If NULL, then tracing is
     *   turned off.
     *
     * Outputs:
     * 
     * - None.
     * @param resource
     * @param string
     */
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    /**
     * Output debug information to output (php://output stream)
     */
    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '';
    }

    /**
     * @var resource|0
     */
    static public $yyTraceFILE;
    /**
     * String to prepend to debug output
     * @var string|0
     */
    static public $yyTracePrompt;
    /**
     * @var int
     */
    public $yyidx = -1;                    /* Index of top element in stack */
    /**
     * @var int
     */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    /**
     * @var array
     */
    public $yystack = array();  /* The parser's stack */

    /**
     * For tracing shifts, the names of all terminals and nonterminals
     * are required.  The following table supplies these names
     * @var array
     */
    static public $yyTokenName = array( 
  '$',             'YY_POST_IF',    'YY_IF',         'YY_ELSE',     
  'YY_FOR',        'YY_DO',         'YY_WHILE',      'YY_UNTIL',    
  'YY_LOOP',       'YY_SUPER',      'YY_CLASS',      'YY_FORIN',    
  'YY_FOROF',      'YY_BY',         'YY_WHEN',       'YY_EQUALS',   
  'YY_COLON',      'YY_COMPOUND_ASSIGN',  'YY_RETURN',     'YY_THROW',    
  'YY_EXTENDS',    'YY_INDENT',     'YY_OUTDENT',    'YY_LOGIC',    
  'YY_COMPARE',    'YY_RELATION',   'YY_SHIFT',      'YY_PLUS',     
  'YY_MINUS',      'YY_MATH',       'YY_UNARY',      'YY_EXISTENTIAL',
  'YY_INCREMENT',  'YY_DECREMENT',  'YY_CALL_START',  'YY_CALL_END', 
  'YY_ACCESSOR',   'YY_EXISTENTIAL_ACCESSOR',  'YY_PROTOTYPE',  'YY_TERMINATOR',
  'YY_STATEMENT',  'YY_IDENTIFIER',  'YY_NUMBER',     'YY_STRING',   
  'YY_JS',         'YY_REGEX',      'YY_BOOL',       'YY_HERECOMMENT',
  'YY_PARAM_START',  'YY_PARAM_END',  'YY_FUNC',       'YY_BOUND_FUNC',
  'YY_COMMA',      'YY_RANGE_EXCLUSIVE',  'YY_INDEX_START',  'YY_INDEX_END',
  'YY_INDEX_SOAK',  'YY_INDEX_PROTO',  'YY_OBJECT_START',  'YY_OBJECT_END',
  'YY_FUNC_EXIST',  'YY_THIS',       'YY_AT_SIGN',    'YY_ARRAY_START',
  'YY_ARRAY_END',  'YY_RANGE_INCLUSIVE',  'YY_TRY',        'YY_FINALLY',  
  'YY_CATCH',      'YY_PAREN_START',  'YY_PAREN_END',  'YY_OWN',      
  'YY_SWITCH',     'YY_LEADING_WHEN',  'error',         'root',        
  'body',          'block',         'line',          'expression',  
  'statement',     'return',        'throw',         'comment',     
  'value',         'invocation',    'code',          'operation',   
  'assign',        'if',            'try',           'while',       
  'for',           'switch',        'class',         'identifier',  
  'alphanumeric',  'literal',       'assignable',    'assignObj',   
  'objAssignable',  'thisProperty',  'paramList',     'funcGlyph',   
  'optComma',      'param',         'paramVar',      'array',       
  'object',        'splat',         'simpleAssignable',  'accessor',    
  'parenthetical',  'range',         'this',          'index',       
  'indexValue',    'slice',         'assignList',    'optFuncExist',
  'arguments',     'argList',       'rangeDots',     'arg',         
  'simpleArgs',    'catch',         'whileSource',   'loop',        
  'forBody',       'forStart',      'forSource',     'forVariables',
  'forValue',      'whens',         'when',          'ifBlock',     
    );

    /**
     * For tracing reduce actions, the names of all rules are required.
     * @var array
     */
    static public $yyRuleName = array(
 /*   0 */ "root ::=",
 /*   1 */ "root ::= body",
 /*   2 */ "root ::= block YY_TERMINATOR",
 /*   3 */ "body ::= line",
 /*   4 */ "body ::= body YY_TERMINATOR line",
 /*   5 */ "body ::= body YY_TERMINATOR",
 /*   6 */ "line ::= expression",
 /*   7 */ "line ::= statement",
 /*   8 */ "statement ::= return",
 /*   9 */ "statement ::= throw",
 /*  10 */ "statement ::= comment",
 /*  11 */ "statement ::= YY_STATEMENT",
 /*  12 */ "expression ::= value",
 /*  13 */ "expression ::= invocation",
 /*  14 */ "expression ::= code",
 /*  15 */ "expression ::= operation",
 /*  16 */ "expression ::= assign",
 /*  17 */ "expression ::= if",
 /*  18 */ "expression ::= try",
 /*  19 */ "expression ::= while",
 /*  20 */ "expression ::= for",
 /*  21 */ "expression ::= switch",
 /*  22 */ "expression ::= class",
 /*  23 */ "block ::= YY_INDENT YY_OUTDENT",
 /*  24 */ "block ::= YY_INDENT body YY_OUTDENT",
 /*  25 */ "identifier ::= YY_IDENTIFIER",
 /*  26 */ "alphanumeric ::= YY_NUMBER",
 /*  27 */ "alphanumeric ::= YY_STRING",
 /*  28 */ "literal ::= alphanumeric",
 /*  29 */ "literal ::= YY_JS",
 /*  30 */ "literal ::= YY_REGEX",
 /*  31 */ "literal ::= YY_BOOL",
 /*  32 */ "assign ::= assignable YY_EQUALS expression",
 /*  33 */ "assign ::= assignable YY_EQUALS YY_INDENT expression YY_OUTDENT",
 /*  34 */ "assignObj ::= objAssignable",
 /*  35 */ "assignObj ::= objAssignable YY_COLON expression",
 /*  36 */ "assignObj ::= objAssignable YY_COLON YY_INDENT expression YY_OUTDENT",
 /*  37 */ "assignObj ::= comment",
 /*  38 */ "objAssignable ::= identifier",
 /*  39 */ "objAssignable ::= alphanumeric",
 /*  40 */ "objAssignable ::= thisProperty",
 /*  41 */ "return ::= YY_RETURN expression",
 /*  42 */ "return ::= YY_RETURN",
 /*  43 */ "comment ::= YY_HERECOMMENT",
 /*  44 */ "code ::= YY_PARAM_START paramList YY_PARAM_END funcGlyph block",
 /*  45 */ "code ::= funcGlyph block",
 /*  46 */ "funcGlyph ::= YY_FUNC",
 /*  47 */ "funcGlyph ::= YY_BOUND_FUNC",
 /*  48 */ "optComma ::=",
 /*  49 */ "optComma ::= YY_COMMA",
 /*  50 */ "paramList ::=",
 /*  51 */ "paramList ::= param",
 /*  52 */ "paramList ::= paramList YY_COMMA param",
 /*  53 */ "param ::= paramVar",
 /*  54 */ "param ::= paramVar YY_RANGE_EXCLUSIVE",
 /*  55 */ "param ::= paramVar YY_EQUALS expression",
 /*  56 */ "paramVar ::= identifier",
 /*  57 */ "paramVar ::= thisProperty",
 /*  58 */ "paramVar ::= array",
 /*  59 */ "paramVar ::= object",
 /*  60 */ "splat ::= expression YY_RANGE_EXCLUSIVE",
 /*  61 */ "simpleAssignable ::= identifier",
 /*  62 */ "simpleAssignable ::= value accessor",
 /*  63 */ "simpleAssignable ::= invocation accessor",
 /*  64 */ "simpleAssignable ::= thisProperty",
 /*  65 */ "assignable ::= simpleAssignable",
 /*  66 */ "assignable ::= array",
 /*  67 */ "assignable ::= object",
 /*  68 */ "value ::= assignable",
 /*  69 */ "value ::= literal",
 /*  70 */ "value ::= parenthetical",
 /*  71 */ "value ::= range",
 /*  72 */ "value ::= this",
 /*  73 */ "accessor ::= YY_ACCESSOR identifier",
 /*  74 */ "accessor ::= YY_EXISTENTIAL_ACCESSOR identifier",
 /*  75 */ "accessor ::= YY_PROTOTYPE identifier",
 /*  76 */ "accessor ::= YY_PROTOTYPE",
 /*  77 */ "accessor ::= index",
 /*  78 */ "index ::= YY_INDEX_START indexValue YY_INDEX_END",
 /*  79 */ "index ::= YY_INDEX_SOAK index",
 /*  80 */ "index ::= YY_INDEX_PROTO index",
 /*  81 */ "indexValue ::= expression",
 /*  82 */ "indexValue ::= slice",
 /*  83 */ "object ::= YY_OBJECT_START assignList optComma YY_OBJECT_END",
 /*  84 */ "assignList ::=",
 /*  85 */ "assignList ::= assignObj",
 /*  86 */ "assignList ::= assignList YY_COMMA assignObj",
 /*  87 */ "assignList ::= assignList optComma YY_TERMINATOR assignObj",
 /*  88 */ "assignList ::= assignList optComma YY_INDENT assignList optComma YY_OUTDENT",
 /*  89 */ "class ::= YY_CLASS",
 /*  90 */ "class ::= YY_CLASS block",
 /*  91 */ "class ::= YY_CLASS YY_EXTENDS value",
 /*  92 */ "class ::= YY_CLASS YY_EXTENDS value block",
 /*  93 */ "class ::= YY_CLASS simpleAssignable",
 /*  94 */ "class ::= YY_CLASS simpleAssignable block",
 /*  95 */ "class ::= YY_CLASS simpleAssignable YY_EXTENDS value",
 /*  96 */ "class ::= YY_CLASS simpleAssignable YY_EXTENDS value block",
 /*  97 */ "invocation ::= value optFuncExist arguments",
 /*  98 */ "invocation ::= invocation optFuncExist arguments",
 /*  99 */ "invocation ::= YY_SUPER",
 /* 100 */ "invocation ::= YY_SUPER arguments",
 /* 101 */ "optFuncExist ::=",
 /* 102 */ "optFuncExist ::= YY_FUNC_EXIST",
 /* 103 */ "arguments ::= YY_CALL_START YY_CALL_END",
 /* 104 */ "arguments ::= YY_CALL_START argList optComma YY_CALL_END",
 /* 105 */ "this ::= YY_THIS",
 /* 106 */ "this ::= YY_AT_SIGN",
 /* 107 */ "thisProperty ::= YY_AT_SIGN identifier",
 /* 108 */ "array ::= YY_ARRAY_START YY_ARRAY_END",
 /* 109 */ "array ::= YY_ARRAY_START argList optComma YY_ARRAY_END",
 /* 110 */ "rangeDots ::= YY_RANGE_INCLUSIVE",
 /* 111 */ "rangeDots ::= YY_RANGE_EXCLUSIVE",
 /* 112 */ "range ::= YY_ARRAY_START expression rangeDots expression YY_ARRAY_END",
 /* 113 */ "slice ::= expression rangeDots expression",
 /* 114 */ "slice ::= expression rangeDots",
 /* 115 */ "slice ::= rangeDots expression",
 /* 116 */ "argList ::= arg",
 /* 117 */ "argList ::= argList YY_COMMA arg",
 /* 118 */ "argList ::= argList optComma YY_TERMINATOR arg",
 /* 119 */ "argList ::= YY_INDENT argList optComma YY_OUTDENT",
 /* 120 */ "argList ::= argList optComma YY_INDENT argList optComma YY_OUTDENT",
 /* 121 */ "arg ::= expression",
 /* 122 */ "arg ::= splat",
 /* 123 */ "simpleArgs ::= expression",
 /* 124 */ "simpleArgs ::= simpleArgs YY_COMMA expression",
 /* 125 */ "try ::= YY_TRY block",
 /* 126 */ "try ::= YY_TRY block catch",
 /* 127 */ "try ::= YY_TRY block YY_FINALLY block",
 /* 128 */ "try ::= YY_TRY block catch YY_FINALLY block",
 /* 129 */ "catch ::= YY_CATCH identifier block",
 /* 130 */ "throw ::= YY_THROW expression",
 /* 131 */ "parenthetical ::= YY_PAREN_START body YY_PAREN_END",
 /* 132 */ "parenthetical ::= YY_PAREN_START YY_INDENT body YY_OUTDENT YY_PAREN_END",
 /* 133 */ "whileSource ::= YY_WHILE expression",
 /* 134 */ "whileSource ::= YY_WHILE expression YY_WHEN expression",
 /* 135 */ "whileSource ::= YY_UNTIL expression",
 /* 136 */ "whileSource ::= YY_UNTIL expression YY_WHEN expression",
 /* 137 */ "while ::= whileSource block",
 /* 138 */ "while ::= statement whileSource",
 /* 139 */ "while ::= expression whileSource",
 /* 140 */ "while ::= loop",
 /* 141 */ "loop ::= YY_LOOP block",
 /* 142 */ "loop ::= YY_LOOP expression",
 /* 143 */ "for ::= statement forBody",
 /* 144 */ "for ::= expression forBody",
 /* 145 */ "for ::= forBody block",
 /* 146 */ "forBody ::= YY_FOR range",
 /* 147 */ "forBody ::= forStart forSource",
 /* 148 */ "forStart ::= YY_FOR forVariables",
 /* 149 */ "forStart ::= YY_FOR YY_OWN forVariables",
 /* 150 */ "forValue ::= identifier",
 /* 151 */ "forValue ::= array",
 /* 152 */ "forValue ::= object",
 /* 153 */ "forVariables ::= forValue",
 /* 154 */ "forVariables ::= forValue YY_COMMA forValue",
 /* 155 */ "forSource ::= YY_FORIN expression",
 /* 156 */ "forSource ::= YY_FOROF expression",
 /* 157 */ "forSource ::= YY_FORIN expression YY_WHEN expression",
 /* 158 */ "forSource ::= YY_FOROF expression YY_WHEN expression",
 /* 159 */ "forSource ::= YY_FORIN expression YY_BY expression",
 /* 160 */ "forSource ::= YY_FORIN expression YY_WHEN expression YY_BY expression",
 /* 161 */ "forSource ::= YY_FORIN expression YY_BY expression YY_WHEN expression",
 /* 162 */ "switch ::= YY_SWITCH expression YY_INDENT whens YY_OUTDENT",
 /* 163 */ "switch ::= YY_SWITCH expression YY_INDENT whens YY_ELSE block YY_OUTDENT",
 /* 164 */ "switch ::= YY_SWITCH YY_INDENT whens YY_OUTDENT",
 /* 165 */ "switch ::= YY_SWITCH YY_INDENT whens YY_ELSE block YY_OUTDENT",
 /* 166 */ "whens ::= when",
 /* 167 */ "whens ::= whens when",
 /* 168 */ "when ::= YY_LEADING_WHEN simpleArgs block",
 /* 169 */ "when ::= YY_LEADING_WHEN simpleArgs block YY_TERMINATOR",
 /* 170 */ "ifBlock ::= YY_IF expression block",
 /* 171 */ "ifBlock ::= ifBlock YY_ELSE YY_IF expression block",
 /* 172 */ "if ::= ifBlock",
 /* 173 */ "if ::= ifBlock YY_ELSE block",
 /* 174 */ "if ::= statement YY_POST_IF expression",
 /* 175 */ "if ::= expression YY_POST_IF expression",
 /* 176 */ "operation ::= YY_UNARY expression",
 /* 177 */ "operation ::= YY_MINUS expression",
 /* 178 */ "operation ::= YY_PLUS expression",
 /* 179 */ "operation ::= YY_DECREMENT simpleAssignable",
 /* 180 */ "operation ::= YY_INCREMENT simpleAssignable",
 /* 181 */ "operation ::= simpleAssignable YY_DECREMENT",
 /* 182 */ "operation ::= simpleAssignable YY_INCREMENT",
 /* 183 */ "operation ::= expression YY_EXISTENTIAL",
 /* 184 */ "operation ::= expression YY_PLUS expression",
 /* 185 */ "operation ::= expression YY_MINUS expression",
 /* 186 */ "operation ::= expression YY_MATH expression",
 /* 187 */ "operation ::= expression YY_SHIFT expression",
 /* 188 */ "operation ::= expression YY_COMPARE expression",
 /* 189 */ "operation ::= expression YY_LOGIC expression",
 /* 190 */ "operation ::= expression YY_RELATION expression",
 /* 191 */ "operation ::= simpleAssignable YY_COMPOUND_ASSIGN expression",
 /* 192 */ "operation ::= simpleAssignable YY_COMPOUND_ASSIGN YY_INDENT expression YY_OUTDENT",
 /* 193 */ "operation ::= simpleAssignable YY_EXTENDS expression",
    );

    /**
     * This function returns the symbolic name associated with a token
     * value.
     * @param int
     * @return string
     */
    static function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count(self::$yyTokenName)) {
            return self::$yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    /**
     * The following function deletes the value associated with a
     * symbol.  The symbol can be either a terminal or nonterminal.
     * @param int the symbol code
     * @param mixed the symbol's value
     */
    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is 
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    /**
     * Pop the parser's stack once.
     *
     * If there is a destructor routine associated with the token which
     * is popped from the stack, then call it.
     *
     * Return the major token number for the symbol popped.
     * @param yyParser
     * @return int
     */
    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . self::tokenName($yytos->major) .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    /**
     * Deallocate and destroy a parser.  Destructors are all called for
     * all stack elements before shutting the parser down.
     */
    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    /**
     * Based on the current state and parser stack, get a list of all
     * possible lookahead tokens
     * @param int
     * @return array
     */
    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    /**
     * Based on the parser state and current parser stack, determine whether
     * the lookahead token is possible.
     * 
     * The parser will convert the token value to an error token if not.  This
     * catches some unusual edge cases where the parser would fail.
     * @param int
     * @return bool
     */
    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

    /**
     * Find the appropriate action for a parser given the terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int The look-ahead token
     */
    function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        self::tokenName($iLookAhead) . " => " .
                        self::tokenName($iFallback) . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Find the appropriate action for a parser given the non-terminal
     * look-ahead token $iLookAhead.
     *
     * If the look-ahead token is self::YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return self::YY_NO_ACTION.
     * @param int Current state number
     * @param int The look-ahead token
     */
    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Perform a shift action.
     * @param int The new state to shift in
     * @param int The major token to shift in
     * @param mixed the minor token to shift in
     */
    function yy_shift($yyNewState, $yyMajor, $yypMinor, $generated = FALSE)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            /* Here code is inserted which will execute if the parser
            ** stack ever overflows */
            return;
        }
        $yytos = new yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        $yytos->generated = $generated;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    self::tokenName($this->yystack[$i]->major));
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    /**
     * The following table contains information about every rule that
     * is used during the reduce.
     *
     * <pre>
     * array(
     *  array(
     *   int $lhs;         Symbol on the left-hand side of the rule
     *   int $nrhs;     Number of right-hand side symbols in the rule
     *  ),...
     * );
     * </pre>
     */
    static public $yyRuleInfo = array(
  array( 'lhs' => 75, 'rhs' => 0 ),
  array( 'lhs' => 75, 'rhs' => 1 ),
  array( 'lhs' => 75, 'rhs' => 2 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 3 ),
  array( 'lhs' => 76, 'rhs' => 2 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 2 ),
  array( 'lhs' => 77, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 5 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 99, 'rhs' => 5 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 2 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 5 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 0 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 0 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 115, 'rhs' => 3 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 4 ),
  array( 'lhs' => 118, 'rhs' => 0 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 4 ),
  array( 'lhs' => 118, 'rhs' => 6 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 2 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 4 ),
  array( 'lhs' => 94, 'rhs' => 2 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 4 ),
  array( 'lhs' => 94, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 119, 'rhs' => 0 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 4 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 5 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 4 ),
  array( 'lhs' => 121, 'rhs' => 4 ),
  array( 'lhs' => 121, 'rhs' => 6 ),
  array( 'lhs' => 123, 'rhs' => 1 ),
  array( 'lhs' => 123, 'rhs' => 1 ),
  array( 'lhs' => 124, 'rhs' => 1 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 4 ),
  array( 'lhs' => 90, 'rhs' => 5 ),
  array( 'lhs' => 125, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 5 ),
  array( 'lhs' => 126, 'rhs' => 2 ),
  array( 'lhs' => 126, 'rhs' => 4 ),
  array( 'lhs' => 126, 'rhs' => 2 ),
  array( 'lhs' => 126, 'rhs' => 4 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 127, 'rhs' => 2 ),
  array( 'lhs' => 127, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 128, 'rhs' => 2 ),
  array( 'lhs' => 128, 'rhs' => 2 ),
  array( 'lhs' => 129, 'rhs' => 2 ),
  array( 'lhs' => 129, 'rhs' => 3 ),
  array( 'lhs' => 132, 'rhs' => 1 ),
  array( 'lhs' => 132, 'rhs' => 1 ),
  array( 'lhs' => 132, 'rhs' => 1 ),
  array( 'lhs' => 131, 'rhs' => 1 ),
  array( 'lhs' => 131, 'rhs' => 3 ),
  array( 'lhs' => 130, 'rhs' => 2 ),
  array( 'lhs' => 130, 'rhs' => 2 ),
  array( 'lhs' => 130, 'rhs' => 4 ),
  array( 'lhs' => 130, 'rhs' => 4 ),
  array( 'lhs' => 130, 'rhs' => 4 ),
  array( 'lhs' => 130, 'rhs' => 6 ),
  array( 'lhs' => 130, 'rhs' => 6 ),
  array( 'lhs' => 93, 'rhs' => 5 ),
  array( 'lhs' => 93, 'rhs' => 7 ),
  array( 'lhs' => 93, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 6 ),
  array( 'lhs' => 133, 'rhs' => 1 ),
  array( 'lhs' => 133, 'rhs' => 2 ),
  array( 'lhs' => 134, 'rhs' => 3 ),
  array( 'lhs' => 134, 'rhs' => 4 ),
  array( 'lhs' => 135, 'rhs' => 3 ),
  array( 'lhs' => 135, 'rhs' => 5 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 5 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
    );

    /**
     * The following table contains a mapping of reduce action to method name
     * that handles the reduction.
     * 
     * If a rule is not set, it has no handler.
     */
    static public $yyReduceMap = array(
        0 => 0,
        23 => 0,
        1 => 1,
        6 => 1,
        7 => 1,
        8 => 1,
        9 => 1,
        10 => 1,
        12 => 1,
        13 => 1,
        14 => 1,
        15 => 1,
        16 => 1,
        17 => 1,
        18 => 1,
        19 => 1,
        20 => 1,
        21 => 1,
        22 => 1,
        28 => 1,
        37 => 1,
        38 => 1,
        39 => 1,
        40 => 1,
        49 => 1,
        56 => 1,
        57 => 1,
        58 => 1,
        59 => 1,
        64 => 1,
        65 => 1,
        68 => 1,
        72 => 1,
        77 => 1,
        121 => 1,
        122 => 1,
        123 => 1,
        140 => 1,
        148 => 1,
        150 => 1,
        166 => 1,
        172 => 1,
        2 => 2,
        5 => 2,
        24 => 2,
        78 => 2,
        3 => 3,
        4 => 4,
        11 => 11,
        25 => 11,
        26 => 11,
        27 => 11,
        29 => 11,
        30 => 11,
        31 => 31,
        32 => 32,
        33 => 33,
        34 => 34,
        61 => 34,
        66 => 34,
        67 => 34,
        69 => 34,
        70 => 34,
        71 => 34,
        151 => 34,
        152 => 34,
        35 => 35,
        36 => 36,
        41 => 41,
        42 => 42,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 47,
        48 => 48,
        50 => 50,
        84 => 50,
        103 => 50,
        51 => 51,
        85 => 51,
        116 => 51,
        153 => 51,
        52 => 52,
        117 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        60 => 60,
        62 => 62,
        63 => 63,
        73 => 73,
        74 => 74,
        75 => 75,
        76 => 76,
        79 => 79,
        80 => 80,
        81 => 81,
        82 => 82,
        83 => 83,
        86 => 86,
        87 => 87,
        88 => 88,
        120 => 88,
        89 => 89,
        90 => 90,
        91 => 91,
        92 => 92,
        93 => 93,
        94 => 94,
        95 => 95,
        96 => 96,
        97 => 97,
        98 => 97,
        99 => 99,
        100 => 100,
        101 => 101,
        102 => 102,
        104 => 104,
        119 => 104,
        105 => 105,
        106 => 105,
        107 => 107,
        108 => 108,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        114 => 114,
        115 => 115,
        118 => 118,
        124 => 124,
        154 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        139 => 138,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 143,
        145 => 145,
        146 => 146,
        147 => 147,
        149 => 149,
        155 => 155,
        156 => 156,
        157 => 157,
        158 => 158,
        159 => 159,
        160 => 160,
        161 => 161,
        162 => 162,
        163 => 163,
        164 => 164,
        165 => 165,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        173 => 173,
        174 => 174,
        175 => 174,
        176 => 176,
        179 => 176,
        180 => 176,
        177 => 177,
        178 => 177,
        181 => 181,
        182 => 181,
        183 => 183,
        184 => 184,
        185 => 184,
        186 => 184,
        187 => 184,
        188 => 184,
        189 => 184,
        190 => 190,
        191 => 191,
        192 => 192,
        193 => 193,
    );
    /* Beginning here are the reduction cases.  A typical example
    ** follows:
    **  #line <lineno> <grammarfile>
    **   function yy_r0($yymsp){ ... }           // User supplied code
    **  #line <lineno> <thisfile>
    */
#line 28 "/var/www/coffeescript-php/grammar.y"
    function yy_r0(){ $this->_retvalue = yy('Block');     }
#line 2653 "/var/www/coffeescript-php/grammar.php"
#line 29 "/var/www/coffeescript-php/grammar.y"
    function yy_r1(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2656 "/var/www/coffeescript-php/grammar.php"
#line 30 "/var/www/coffeescript-php/grammar.y"
    function yy_r2(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2659 "/var/www/coffeescript-php/grammar.php"
#line 32 "/var/www/coffeescript-php/grammar.y"
    function yy_r3(){ $this->_retvalue = yy_Block::wrap(array($this->yystack[$this->yyidx + 0]->minor));     }
#line 2662 "/var/www/coffeescript-php/grammar.php"
#line 33 "/var/www/coffeescript-php/grammar.y"
    function yy_r4(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor->push($this->yystack[$this->yyidx + 0]->minor);     }
#line 2665 "/var/www/coffeescript-php/grammar.php"
#line 42 "/var/www/coffeescript-php/grammar.y"
    function yy_r11(){ $this->_retvalue = yy('Literal', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2668 "/var/www/coffeescript-php/grammar.php"
#line 67 "/var/www/coffeescript-php/grammar.y"
    function yy_r31(){ $val = yy('Literal', $this->yystack[$this->yyidx + 0]->minor);
                                    $val->is_undefined($this->yystack[$this->yyidx + 0]->minor === 'undefined');
                                    $this->_retvalue = $val;     }
#line 2673 "/var/www/coffeescript-php/grammar.php"
#line 71 "/var/www/coffeescript-php/grammar.y"
    function yy_r32(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2676 "/var/www/coffeescript-php/grammar.php"
#line 72 "/var/www/coffeescript-php/grammar.y"
    function yy_r33(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2679 "/var/www/coffeescript-php/grammar.php"
#line 74 "/var/www/coffeescript-php/grammar.y"
    function yy_r34(){ $this->_retvalue = yy('Value', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2682 "/var/www/coffeescript-php/grammar.php"
#line 75 "/var/www/coffeescript-php/grammar.y"
    function yy_r35(){ $this->_retvalue = yy('Assign', yy('Value', $this->yystack[$this->yyidx + -2]->minor), $this->yystack[$this->yyidx + 0]->minor, 'object');     }
#line 2685 "/var/www/coffeescript-php/grammar.php"
#line 76 "/var/www/coffeescript-php/grammar.y"
    function yy_r36(){ $this->_retvalue = yy('Assign', yy('Value', $this->yystack[$this->yyidx + -4]->minor), $this->yystack[$this->yyidx + -1]->minor, 'object');     }
#line 2688 "/var/www/coffeescript-php/grammar.php"
#line 83 "/var/www/coffeescript-php/grammar.y"
    function yy_r41(){ $this->_retvalue = yy('Return', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2691 "/var/www/coffeescript-php/grammar.php"
#line 84 "/var/www/coffeescript-php/grammar.y"
    function yy_r42(){ $this->_retvalue = yy('Return');     }
#line 2694 "/var/www/coffeescript-php/grammar.php"
#line 86 "/var/www/coffeescript-php/grammar.y"
    function yy_r43(){ $this->_retvalue = yy('Comment', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2697 "/var/www/coffeescript-php/grammar.php"
#line 88 "/var/www/coffeescript-php/grammar.y"
    function yy_r44(){ $this->_retvalue = yy('Code', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2700 "/var/www/coffeescript-php/grammar.php"
#line 89 "/var/www/coffeescript-php/grammar.y"
    function yy_r45(){ $this->_retvalue = yy('Code', array(), $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2703 "/var/www/coffeescript-php/grammar.php"
#line 91 "/var/www/coffeescript-php/grammar.y"
    function yy_r46(){ $this->_retvalue = 'func';     }
#line 2706 "/var/www/coffeescript-php/grammar.php"
#line 92 "/var/www/coffeescript-php/grammar.y"
    function yy_r47(){ $this->_retvalue = 'boundfunc';     }
#line 2709 "/var/www/coffeescript-php/grammar.php"
#line 94 "/var/www/coffeescript-php/grammar.y"
    function yy_r48(){ $this->_retvalue = '';     }
#line 2712 "/var/www/coffeescript-php/grammar.php"
#line 97 "/var/www/coffeescript-php/grammar.y"
    function yy_r50(){ $this->_retvalue = array();     }
#line 2715 "/var/www/coffeescript-php/grammar.php"
#line 98 "/var/www/coffeescript-php/grammar.y"
    function yy_r51(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);     }
#line 2718 "/var/www/coffeescript-php/grammar.php"
#line 99 "/var/www/coffeescript-php/grammar.y"
    function yy_r52(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor, array($this->yystack[$this->yyidx + 0]->minor));     }
#line 2721 "/var/www/coffeescript-php/grammar.php"
#line 101 "/var/www/coffeescript-php/grammar.y"
    function yy_r53(){ $this->_retvalue = yy('Param', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2724 "/var/www/coffeescript-php/grammar.php"
#line 102 "/var/www/coffeescript-php/grammar.y"
    function yy_r54(){ $this->_retvalue = yy('Param', $this->yystack[$this->yyidx + -1]->minor, NULL, TRUE);     }
#line 2727 "/var/www/coffeescript-php/grammar.php"
#line 103 "/var/www/coffeescript-php/grammar.y"
    function yy_r55(){ $this->_retvalue = yy('Param', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2730 "/var/www/coffeescript-php/grammar.php"
#line 110 "/var/www/coffeescript-php/grammar.y"
    function yy_r60(){ $this->_retvalue = yy('Splat', $this->yystack[$this->yyidx + -1]->minor);     }
#line 2733 "/var/www/coffeescript-php/grammar.php"
#line 113 "/var/www/coffeescript-php/grammar.y"
    function yy_r62(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->push($this->yystack[$this->yyidx + 0]->minor);     }
#line 2736 "/var/www/coffeescript-php/grammar.php"
#line 114 "/var/www/coffeescript-php/grammar.y"
    function yy_r63(){ $this->_retvalue = yy('Value', $this->yystack[$this->yyidx + -1]->minor, array($this->yystack[$this->yyidx + 0]->minor));     }
#line 2739 "/var/www/coffeescript-php/grammar.php"
#line 127 "/var/www/coffeescript-php/grammar.y"
    function yy_r73(){ $this->_retvalue = yy('Access', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2742 "/var/www/coffeescript-php/grammar.php"
#line 128 "/var/www/coffeescript-php/grammar.y"
    function yy_r74(){ $this->_retvalue = yy('Access', $this->yystack[$this->yyidx + 0]->minor, 'soak');     }
#line 2745 "/var/www/coffeescript-php/grammar.php"
#line 129 "/var/www/coffeescript-php/grammar.y"
    function yy_r75(){ $this->_retvalue = yy('Access', $this->yystack[$this->yyidx + 0]->minor, 'proto');     }
#line 2748 "/var/www/coffeescript-php/grammar.php"
#line 130 "/var/www/coffeescript-php/grammar.y"
    function yy_r76(){ $this->_retvalue = yy('Access', yy('Literal', 'prototype'));     }
#line 2751 "/var/www/coffeescript-php/grammar.php"
#line 134 "/var/www/coffeescript-php/grammar.y"
    function yy_r79(){ $this->_retvalue = extend($this->yystack[$this->yyidx + 0]->minor, array('soak' => TRUE));     }
#line 2754 "/var/www/coffeescript-php/grammar.php"
#line 135 "/var/www/coffeescript-php/grammar.y"
    function yy_r80(){ $this->_retvalue = extend($this->yystack[$this->yyidx + 0]->minor, array('proto' => TRUE));     }
#line 2757 "/var/www/coffeescript-php/grammar.php"
#line 137 "/var/www/coffeescript-php/grammar.y"
    function yy_r81(){ $this->_retvalue = yy('Index', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2760 "/var/www/coffeescript-php/grammar.php"
#line 138 "/var/www/coffeescript-php/grammar.y"
    function yy_r82(){ $this->_retvalue = yy('Slice', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2763 "/var/www/coffeescript-php/grammar.php"
#line 140 "/var/www/coffeescript-php/grammar.y"
    function yy_r83(){ $this->_retvalue = yy('Obj', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx - 3]->generated);     }
#line 2766 "/var/www/coffeescript-php/grammar.php"
#line 144 "/var/www/coffeescript-php/grammar.y"
    function yy_r86(){ $this->yystack[$this->yyidx + -2]->minor[] = $this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;     }
#line 2769 "/var/www/coffeescript-php/grammar.php"
#line 145 "/var/www/coffeescript-php/grammar.y"
    function yy_r87(){ $this->yystack[$this->yyidx + -3]->minor[] = $this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;     }
#line 2772 "/var/www/coffeescript-php/grammar.php"
#line 146 "/var/www/coffeescript-php/grammar.y"
    function yy_r88(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -2]->minor);     }
#line 2775 "/var/www/coffeescript-php/grammar.php"
#line 148 "/var/www/coffeescript-php/grammar.y"
    function yy_r89(){ $this->_retvalue = yy('Class');     }
#line 2778 "/var/www/coffeescript-php/grammar.php"
#line 149 "/var/www/coffeescript-php/grammar.y"
    function yy_r90(){ $this->_retvalue = yy('Class', NULL, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2781 "/var/www/coffeescript-php/grammar.php"
#line 150 "/var/www/coffeescript-php/grammar.y"
    function yy_r91(){ $this->_retvalue = yy('Class', NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2784 "/var/www/coffeescript-php/grammar.php"
#line 151 "/var/www/coffeescript-php/grammar.y"
    function yy_r92(){ $this->_retvalue = yy('Class', NULL, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2787 "/var/www/coffeescript-php/grammar.php"
#line 152 "/var/www/coffeescript-php/grammar.y"
    function yy_r93(){ $this->_retvalue = yy('Class', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2790 "/var/www/coffeescript-php/grammar.php"
#line 153 "/var/www/coffeescript-php/grammar.y"
    function yy_r94(){ $this->_retvalue = yy('Class', $this->yystack[$this->yyidx + -1]->minor, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2793 "/var/www/coffeescript-php/grammar.php"
#line 154 "/var/www/coffeescript-php/grammar.y"
    function yy_r95(){ $this->_retvalue = yy('Class', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2796 "/var/www/coffeescript-php/grammar.php"
#line 155 "/var/www/coffeescript-php/grammar.y"
    function yy_r96(){ $this->_retvalue = yy('Class', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2799 "/var/www/coffeescript-php/grammar.php"
#line 157 "/var/www/coffeescript-php/grammar.y"
    function yy_r97(){ $this->_retvalue = yy('Call', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2802 "/var/www/coffeescript-php/grammar.php"
#line 159 "/var/www/coffeescript-php/grammar.y"
    function yy_r99(){ $this->_retvalue = yy('Call', 'super', array(yy('Splat', yy('Literal', 'arguments'))));     }
#line 2805 "/var/www/coffeescript-php/grammar.php"
#line 160 "/var/www/coffeescript-php/grammar.y"
    function yy_r100(){ $this->_retvalue = yy('Call', 'super', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2808 "/var/www/coffeescript-php/grammar.php"
#line 162 "/var/www/coffeescript-php/grammar.y"
    function yy_r101(){ $this->_retvalue = FALSE;     }
#line 2811 "/var/www/coffeescript-php/grammar.php"
#line 163 "/var/www/coffeescript-php/grammar.y"
    function yy_r102(){ $this->_retvalue = TRUE;     }
#line 2814 "/var/www/coffeescript-php/grammar.php"
#line 166 "/var/www/coffeescript-php/grammar.y"
    function yy_r104(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;     }
#line 2817 "/var/www/coffeescript-php/grammar.php"
#line 168 "/var/www/coffeescript-php/grammar.y"
    function yy_r105(){ $this->_retvalue = yy('Value', yy('Literal', 'this'));     }
#line 2820 "/var/www/coffeescript-php/grammar.php"
#line 171 "/var/www/coffeescript-php/grammar.y"
    function yy_r107(){ $this->_retvalue = yy('Value', yy('Literal', 'this'), array(yy('Access', $this->yystack[$this->yyidx + 0]->minor)), 'this');     }
#line 2823 "/var/www/coffeescript-php/grammar.php"
#line 173 "/var/www/coffeescript-php/grammar.y"
    function yy_r108(){ $this->_retvalue = yy('Arr', array());     }
#line 2826 "/var/www/coffeescript-php/grammar.php"
#line 174 "/var/www/coffeescript-php/grammar.y"
    function yy_r109(){ $this->_retvalue = yy('Arr', $this->yystack[$this->yyidx + -2]->minor);     }
#line 2829 "/var/www/coffeescript-php/grammar.php"
#line 176 "/var/www/coffeescript-php/grammar.y"
    function yy_r110(){ $this->_retvalue = 'inclusive';     }
#line 2832 "/var/www/coffeescript-php/grammar.php"
#line 177 "/var/www/coffeescript-php/grammar.y"
    function yy_r111(){ $this->_retvalue = 'exclusive';     }
#line 2835 "/var/www/coffeescript-php/grammar.php"
#line 179 "/var/www/coffeescript-php/grammar.y"
    function yy_r112(){ $this->_retvalue = yy('Range', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor);     }
#line 2838 "/var/www/coffeescript-php/grammar.php"
#line 181 "/var/www/coffeescript-php/grammar.y"
    function yy_r113(){ $this->_retvalue = yy('Range', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2841 "/var/www/coffeescript-php/grammar.php"
#line 182 "/var/www/coffeescript-php/grammar.y"
    function yy_r114(){ $this->_retvalue = yy('Range', $this->yystack[$this->yyidx + -1]->minor, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2844 "/var/www/coffeescript-php/grammar.php"
#line 183 "/var/www/coffeescript-php/grammar.y"
    function yy_r115(){ $this->_retvalue = yy('Range', NULL, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2847 "/var/www/coffeescript-php/grammar.php"
#line 187 "/var/www/coffeescript-php/grammar.y"
    function yy_r118(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -3]->minor, array($this->yystack[$this->yyidx + 0]->minor));     }
#line 2850 "/var/www/coffeescript-php/grammar.php"
#line 195 "/var/www/coffeescript-php/grammar.y"
    function yy_r124(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2853 "/var/www/coffeescript-php/grammar.php"
#line 197 "/var/www/coffeescript-php/grammar.y"
    function yy_r125(){ $this->_retvalue = yy('Try', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2856 "/var/www/coffeescript-php/grammar.php"
#line 198 "/var/www/coffeescript-php/grammar.y"
    function yy_r126(){ $this->_retvalue = yy('Try', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor[0], $this->yystack[$this->yyidx + 0]->minor[1]);      }
#line 2859 "/var/www/coffeescript-php/grammar.php"
#line 199 "/var/www/coffeescript-php/grammar.y"
    function yy_r127(){ $this->_retvalue = yy('Try', $this->yystack[$this->yyidx + -2]->minor, NULL, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2862 "/var/www/coffeescript-php/grammar.php"
#line 200 "/var/www/coffeescript-php/grammar.y"
    function yy_r128(){ $this->_retvalue = yy('Try', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -2]->minor[0], $this->yystack[$this->yyidx + -2]->minor[1], $this->yystack[$this->yyidx + 0]->minor);     }
#line 2865 "/var/www/coffeescript-php/grammar.php"
#line 202 "/var/www/coffeescript-php/grammar.y"
    function yy_r129(){ $this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2868 "/var/www/coffeescript-php/grammar.php"
#line 204 "/var/www/coffeescript-php/grammar.y"
    function yy_r130(){ $this->_retvalue = yy('Throw', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2871 "/var/www/coffeescript-php/grammar.php"
#line 206 "/var/www/coffeescript-php/grammar.y"
    function yy_r131(){ $this->_retvalue = yy('Parens', $this->yystack[$this->yyidx + -1]->minor);     }
#line 2874 "/var/www/coffeescript-php/grammar.php"
#line 207 "/var/www/coffeescript-php/grammar.y"
    function yy_r132(){ $this->_retvalue = yy('Parens', $this->yystack[$this->yyidx + -2]->minor);     }
#line 2877 "/var/www/coffeescript-php/grammar.php"
#line 209 "/var/www/coffeescript-php/grammar.y"
    function yy_r133(){ $this->_retvalue = yy('While', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2880 "/var/www/coffeescript-php/grammar.php"
#line 210 "/var/www/coffeescript-php/grammar.y"
    function yy_r134(){ $this->_retvalue = yy('While', $this->yystack[$this->yyidx + -2]->minor, array('guard' => $this->yystack[$this->yyidx + 0]->minor));     }
#line 2883 "/var/www/coffeescript-php/grammar.php"
#line 211 "/var/www/coffeescript-php/grammar.y"
    function yy_r135(){ $this->_retvalue = yy('While', $this->yystack[$this->yyidx + 0]->minor, array('invert' => TRUE));     }
#line 2886 "/var/www/coffeescript-php/grammar.php"
#line 212 "/var/www/coffeescript-php/grammar.y"
    function yy_r136(){ $this->_retvalue = yy('While', $this->yystack[$this->yyidx + -2]->minor, array('invert' => TRUE, 'guard' => $this->yystack[$this->yyidx + 0]->minor));     }
#line 2889 "/var/www/coffeescript-php/grammar.php"
#line 214 "/var/www/coffeescript-php/grammar.y"
    function yy_r137(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->add_body($this->yystack[$this->yyidx + 0]->minor);     }
#line 2892 "/var/www/coffeescript-php/grammar.php"
#line 215 "/var/www/coffeescript-php/grammar.y"
    function yy_r138(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor->add_body(yy_Block::wrap(array($this->yystack[$this->yyidx + -1]->minor)));     }
#line 2895 "/var/www/coffeescript-php/grammar.php"
#line 219 "/var/www/coffeescript-php/grammar.y"
    function yy_r141(){ $this->_retvalue = yy('While', yy('Literal', 'true')); $this->_retvalue->add_body($this->yystack[$this->yyidx + 0]->minor);     }
#line 2898 "/var/www/coffeescript-php/grammar.php"
#line 220 "/var/www/coffeescript-php/grammar.y"
    function yy_r142(){ $this->_retvalue = yy('While', yy('Literal', 'true')); $this->_retvalue->add_body(yy_Block::wrap($this->yystack[$this->yyidx + 0]->minor));     }
#line 2901 "/var/www/coffeescript-php/grammar.php"
#line 222 "/var/www/coffeescript-php/grammar.y"
    function yy_r143(){ $this->_retvalue = yy('For', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2904 "/var/www/coffeescript-php/grammar.php"
#line 224 "/var/www/coffeescript-php/grammar.y"
    function yy_r145(){ $this->_retvalue = yy('For', $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2907 "/var/www/coffeescript-php/grammar.php"
#line 226 "/var/www/coffeescript-php/grammar.y"
    function yy_r146(){ $this->_retvalue = array('source' => yy('Value', $this->yystack[$this->yyidx + 0]->minor));     }
#line 2910 "/var/www/coffeescript-php/grammar.php"
#line 227 "/var/www/coffeescript-php/grammar.y"
    function yy_r147(){ $this->yystack[$this->yyidx + 0]->minor['own'] = isset($this->yystack[$this->yyidx + -1]->minor['own']) ? $this->yystack[$this->yyidx + -1]->minor['own'] : NULL; $this->yystack[$this->yyidx + 0]->minor['name'] = $this->yystack[$this->yyidx + -1]->minor[0]; $this->yystack[$this->yyidx + 0]->minor['index'] = isset($this->yystack[$this->yyidx + -1]->minor[1]) ? $this->yystack[$this->yyidx + -1]->minor[1] : NULL; $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2913 "/var/www/coffeescript-php/grammar.php"
#line 230 "/var/www/coffeescript-php/grammar.y"
    function yy_r149(){ $this->yystack[$this->yyidx + 0]->minor['own'] = TRUE; $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2916 "/var/www/coffeescript-php/grammar.php"
#line 239 "/var/www/coffeescript-php/grammar.y"
    function yy_r155(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2919 "/var/www/coffeescript-php/grammar.php"
#line 240 "/var/www/coffeescript-php/grammar.y"
    function yy_r156(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + 0]->minor, 'object' => TRUE);     }
#line 2922 "/var/www/coffeescript-php/grammar.php"
#line 241 "/var/www/coffeescript-php/grammar.y"
    function yy_r157(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -2]->minor, 'guard' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2925 "/var/www/coffeescript-php/grammar.php"
#line 242 "/var/www/coffeescript-php/grammar.y"
    function yy_r158(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -2]->minor, 'guard' => $this->yystack[$this->yyidx + 0]->minor, 'object' => TRUE);     }
#line 2928 "/var/www/coffeescript-php/grammar.php"
#line 243 "/var/www/coffeescript-php/grammar.y"
    function yy_r159(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -2]->minor, 'step' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2931 "/var/www/coffeescript-php/grammar.php"
#line 244 "/var/www/coffeescript-php/grammar.y"
    function yy_r160(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -4]->minor, 'guard' => $this->yystack[$this->yyidx + -2]->minor, 'step' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2934 "/var/www/coffeescript-php/grammar.php"
#line 245 "/var/www/coffeescript-php/grammar.y"
    function yy_r161(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -4]->minor, 'step' => $this->yystack[$this->yyidx + -2]->minor, 'guard' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2937 "/var/www/coffeescript-php/grammar.php"
#line 247 "/var/www/coffeescript-php/grammar.y"
    function yy_r162(){ $this->_retvalue = yy('Switch', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2940 "/var/www/coffeescript-php/grammar.php"
#line 248 "/var/www/coffeescript-php/grammar.y"
    function yy_r163(){ $this->_retvalue = yy('Switch', $this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2943 "/var/www/coffeescript-php/grammar.php"
#line 249 "/var/www/coffeescript-php/grammar.y"
    function yy_r164(){ $this->_retvalue = yy('Switch', NULL, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2946 "/var/www/coffeescript-php/grammar.php"
#line 250 "/var/www/coffeescript-php/grammar.y"
    function yy_r165(){ $this->_retvalue = yy('Switch', NULL, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2949 "/var/www/coffeescript-php/grammar.php"
#line 253 "/var/www/coffeescript-php/grammar.y"
    function yy_r167(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2952 "/var/www/coffeescript-php/grammar.php"
#line 255 "/var/www/coffeescript-php/grammar.y"
    function yy_r168(){ $this->_retvalue = array(array($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor));     }
#line 2955 "/var/www/coffeescript-php/grammar.php"
#line 256 "/var/www/coffeescript-php/grammar.y"
    function yy_r169(){ $this->_retvalue = array(array($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor));     }
#line 2958 "/var/www/coffeescript-php/grammar.php"
#line 258 "/var/www/coffeescript-php/grammar.y"
    function yy_r170(){ $this->_retvalue = yy('If', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor, array('type' => $this->yystack[$this->yyidx + -2]->minor));     }
#line 2961 "/var/www/coffeescript-php/grammar.php"
#line 259 "/var/www/coffeescript-php/grammar.y"
    function yy_r171(){ $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor->add_else(yy('If', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor, array('type' => $this->yystack[$this->yyidx + -2]->minor)));     }
#line 2964 "/var/www/coffeescript-php/grammar.php"
#line 262 "/var/www/coffeescript-php/grammar.y"
    function yy_r173(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor->add_else($this->yystack[$this->yyidx + 0]->minor);     }
#line 2967 "/var/www/coffeescript-php/grammar.php"
#line 263 "/var/www/coffeescript-php/grammar.y"
    function yy_r174(){ $this->_retvalue = yy('If', $this->yystack[$this->yyidx + 0]->minor, yy_Block::wrap(array($this->yystack[$this->yyidx + -2]->minor)), array('type' => $this->yystack[$this->yyidx + -1]->minor, 'statement' => TRUE));     }
#line 2970 "/var/www/coffeescript-php/grammar.php"
#line 266 "/var/www/coffeescript-php/grammar.y"
    function yy_r176(){ $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2973 "/var/www/coffeescript-php/grammar.php"
#line 267 "/var/www/coffeescript-php/grammar.y"
    function yy_r177(){ $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor); /* prec: 'UNARY'; */     }
#line 2976 "/var/www/coffeescript-php/grammar.php"
#line 271 "/var/www/coffeescript-php/grammar.y"
    function yy_r181(){ $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor, NULL, TRUE);     }
#line 2979 "/var/www/coffeescript-php/grammar.php"
#line 273 "/var/www/coffeescript-php/grammar.y"
    function yy_r183(){ $this->_retvalue = yy('Existence', $this->yystack[$this->yyidx + -1]->minor);     }
#line 2982 "/var/www/coffeescript-php/grammar.php"
#line 274 "/var/www/coffeescript-php/grammar.y"
    function yy_r184(){ $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2985 "/var/www/coffeescript-php/grammar.php"
#line 280 "/var/www/coffeescript-php/grammar.y"
    function yy_r190(){ if ($this->yystack[$this->yyidx + -1]->minor{0} === '!') { $this->_retvalue = yy('Op', substr($this->yystack[$this->yyidx + -1]->minor, 1), $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor); $this->_retvalue->invert(); } else { $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor); }     }
#line 2988 "/var/www/coffeescript-php/grammar.php"
#line 281 "/var/www/coffeescript-php/grammar.y"
    function yy_r191(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2991 "/var/www/coffeescript-php/grammar.php"
#line 282 "/var/www/coffeescript-php/grammar.y"
    function yy_r192(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -3]->minor);     }
#line 2994 "/var/www/coffeescript-php/grammar.php"
#line 283 "/var/www/coffeescript-php/grammar.y"
    function yy_r193(){ $this->_retvalue = yy('Extends', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2997 "/var/www/coffeescript-php/grammar.php"

    /**
     * placeholder for the left hand side in a reduce operation.
     * 
     * For a parser with a rule like this:
     * <pre>
     * rule(A) ::= B. { A = 1; }
     * </pre>
     * 
     * The parser will translate to something like:
     * 
     * <code>
     * function yy_r0(){$this->_retvalue = 1;}
     * </code>
     */
    private $_retvalue;

    /**
     * Perform a reduce action and the shift that must immediately
     * follow the reduce.
     * 
     * For a rule such as:
     * 
     * <pre>
     * A ::= B blah C. { dosomething(); }
     * </pre>
     * 
     * This function will first call the action, if any, ("dosomething();" in our
     * example), and then it will pop three states from the stack,
     * one for each entry on the right-hand side of the expression
     * (B, blah, and C in our example rule), and then push the result of the action
     * back on to the stack with the resulting state reduced to (as described in the .out
     * file)
     * @param int Number of the rule by which to reduce
     */
    function yy_reduce($yyruleno)
    {
        //int $yygoto;                     /* The next state */
        //int $yyact;                      /* The next action */
        //mixed $yygotominor;        /* The LHS of the rule reduced */
        //yyStackEntry $yymsp;            /* The top of the parser's stack */
        //int $yysize;                     /* Amount to pop the stack */
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            /* If we are not debugging and the reduce action popped at least
            ** one element off the stack, then we can push the new element back
            ** onto the stack here, and skip the stack overflow test in yy_shift().
            ** That gives a significant speed improvement. */
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    /**
     * The following code executes when the parse fails
     * 
     * Code from %parse_fail is inserted here
     */
    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser fails */
    }

    /**
     * The following code executes when a syntax error first occurs.
     * 
     * %syntax_error code is inserted here
     * @param int The major type of the error token
     * @param mixed The minor type of the error token
     */
    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 4 "/var/www/coffeescript-php/grammar.y"
 
  throw new SyntaxError(
    'unexpected '.$this->tokenName($yymajor).' in '.self::$FILE.':'
  . (self::$LINE + 1).'.'
  );
#line 3116 "/var/www/coffeescript-php/grammar.php"
    }

    /**
     * The following is executed when the parser accepts
     * 
     * %parse_accept code is inserted here
     */
    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser accepts */
    }

    /**
     * The main parser program.
     * 
     * The first argument is the major token number.  The second is
     * the token value string as scanned from the input.
     *
     * @param int   $yymajor      the token number
     * @param mixed $yytokenvalue the token value
     * @param mixed ...           any extra arguments that should be passed to handlers
     *
     * @return void
     */
    function parse($token)
    {
        list($yymajor, $yytokenvalue, ) = $token ? $token : array(0, 0);
        self::$LINE = isset($token[2]) ? $token[2] : -1;

        // See rewriter.php\add_implicit_braces() and grammar.y.
        $generated = isset($token['generatedValue']) ? $token['generatedValue'] : FALSE;

//        $yyact;            /* The parser action. */
//        $yyendofinput;     /* True if we are at the end of input */
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        /* (re)initialize the parser, if necessary */
        if ($this->yyidx === null || $this->yyidx < 0) {
            /* if ($yymajor == 0) return; // not sure why this was here... */
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $x->generated = FALSE;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(
                self::$yyTraceFILE,
                "%sInput %s\n",
                self::$yyTracePrompt,
                self::tokenName($yymajor)
            );
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL
                && !$this->yy_is_expected_token($yymajor)
            ) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue, $generated);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(
                        self::$yyTraceFILE,
                        "%sSyntax Error!\n",
                        self::$yyTracePrompt
                    );
                }
                if (self::YYERRORSYMBOL) {
                    /* A syntax error has occurred.
                    ** The response to an error depends upon whether or not the
                    ** grammar defines an error token "ERROR".  
                    **
                    ** This is what we do if the grammar does define ERROR:
                    **
                    **  * Call the %syntax_error function.
                    **
                    **  * Begin popping the stack until we enter a state where
                    **    it is legal to shift the error symbol, then shift
                    **    the error symbol.
                    **
                    **  * Set the error count to three.
                    **
                    **  * Begin accepting and shifting new tokens.  No new error
                    **    processing will occur until three tokens have been
                    **    shifted successfully.
                    **
                    */
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ) {
                        if (self::$yyTraceFILE) {
                            fprintf(
                                self::$yyTraceFILE,
                                "%sDiscard input token %s\n",
                                self::$yyTracePrompt,
                                self::tokenName($yymajor)
                            );
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0
                            && $yymx != self::YYERRORSYMBOL
                            && ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                        ) {
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2, $generated);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    /* YYERRORSYMBOL is not defined */
                    /* This is what we do if the grammar does not define ERROR:
                    **
                    **  * Report an error message, and throw away the input token.
                    **
                    **  * If the input token is $, then fail the parse.
                    **
                    ** As before, subsequent error messages are suppressed until
                    ** three input tokens have been successfully shifted.
                    */
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);

        if ($token === NULL)
        {
          return $this->_retvalue;
        }
    }
}
