<?php

require_once 'Vitis.class.inc';
require_once __DIR__ . '/../../class/vitis_lib/Connection.class.inc';

/**
 * \file TimeZone.class.inc
 * \class TimeZone
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the TimeZone php class
 *
 * This class defines operation for one TimeZone
 * 
 */
class TimeZone extends Vitis {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("name", "abbrev", "utc_offset", 'is_dst', "CONCAT(name, ' ', 'GMT',' ',substr(CASE WHEN (substr(utc_offset::text, 1, 1) = '-') THEN utc_offset::text ELSE CONCAT('+', utc_offset) END::text, 1, 6)) as label");
    }

    /**
     * @SWG\Get(path="/timezones/{name}",
     *   tags={"TimeZones"},
     *   summary="Get TimeZone",
     *   description="Request to get TimeZone by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="name",
     *     in="path",
     *     description="timezone name",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/timezones")
     *     )
     *  )
     */

    /**
     * get informations about mode
     */
    function GET() {
        require $this->sRessourcesFile;
        $this->aFields = $this->getFields('pg_catalog', 'pg_timezone_names', 'name');
    }
}
?>